/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition.form;

import java.util.ArrayList;
import java.util.List;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinition;
import org.activiti.workflow.simple.definition.form.ListPropertyEntry;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonTypeName(value="list")
public class ListPropertyDefinition
extends FormPropertyDefinition {
    protected List<ListPropertyEntry> entries = new ArrayList<ListPropertyEntry>();

    public void setEntries(List<ListPropertyEntry> entries) {
        this.entries = entries;
    }

    @JsonSerialize(contentAs=ListPropertyEntry.class)
    public List<ListPropertyEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(ListPropertyEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public FormPropertyDefinition clone() {
        ListPropertyDefinition clone = new ListPropertyDefinition();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(FormPropertyDefinition otherDefinition) {
        if (!(otherDefinition instanceof ListPropertyDefinition)) {
            throw new SimpleWorkflowException("An instance of ListPropertyDefinition is required to set values");
        }
        ListPropertyDefinition datePropertyDefinition = (ListPropertyDefinition)otherDefinition;
        this.setName(datePropertyDefinition.getName());
        this.setMandatory(datePropertyDefinition.isMandatory());
        this.setWritable(datePropertyDefinition.isWritable());
        if (this.entries == null) {
            this.entries = new ArrayList<ListPropertyEntry>();
        } else {
            this.entries.clear();
        }
        if (datePropertyDefinition.getEntries() != null) {
            ListPropertyEntry newEntry = null;
            for (ListPropertyEntry entry : datePropertyDefinition.getEntries()) {
                newEntry = new ListPropertyEntry(entry.getValue(), entry.getName());
                this.entries.add(newEntry);
            }
        }
        this.setParameters(otherDefinition.cloneParameters());
    }
}

