/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;

@InterfaceAudience.Private
public abstract class AbstractDataBlockEncoder
implements DataBlockEncoder {
    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding, byte[] header, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(encoding, header, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    protected void postEncoding(HFileBlockEncodingContext encodingCtx) throws IOException {
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    protected static abstract class AbstractEncodedSeeker
    implements DataBlockEncoder.EncodedSeeker {
        protected HFileBlockDecodingContext decodingCtx;
        protected final KeyValue.KVComparator comparator;

        public AbstractEncodedSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
            this.comparator = comparator;
            this.decodingCtx = decodingCtx;
        }

        protected boolean includesMvcc() {
            return this.decodingCtx.getHFileContext().isIncludesMvcc();
        }

        protected boolean includesTags() {
            return this.decodingCtx.getHFileContext().isIncludesTags();
        }
    }
}

