/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.api.config.encrypt.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptorRuleConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class EncryptRuleBeanDefinitionParser {
    public static AbstractBeanDefinition parseEncryptRuleElement(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptRuleConfiguration.class);
        factory.addConstructorArgValue(EncryptRuleBeanDefinitionParser.parseEncryptorRuleConfigurations(element));
        factory.addConstructorArgValue(EncryptRuleBeanDefinitionParser.parseEncryptTableRuleConfigurations(element));
        return factory.getBeanDefinition();
    }

    private static Map<String, BeanDefinition> parseEncryptorRuleConfigurations(Element element) {
        Element encryptorsRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"encryptors");
        List encryptorRuleElements = DomUtils.getChildElementsByTagName((Element)encryptorsRuleElement, (String)"encryptor");
        ManagedMap result = new ManagedMap(encryptorRuleElements.size());
        for (Element each : encryptorRuleElements) {
            result.put(each.getAttribute("id"), EncryptRuleBeanDefinitionParser.parseEncryptorRuleConfiguration(each));
        }
        return result;
    }

    private static AbstractBeanDefinition parseEncryptorRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptorRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("type"));
        EncryptRuleBeanDefinitionParser.parseProperties(element, factory);
        return factory.getBeanDefinition();
    }

    private static void parseProperties(Element element, BeanDefinitionBuilder factory) {
        String properties = element.getAttribute("props-ref");
        if (!Strings.isNullOrEmpty((String)properties)) {
            factory.addConstructorArgReference(properties);
        } else {
            factory.addConstructorArgValue((Object)new Properties());
        }
    }

    private static Map<String, BeanDefinition> parseEncryptTableRuleConfigurations(Element element) {
        Element encryptTablesElement = DomUtils.getChildElementByTagName((Element)element, (String)"tables");
        List encryptTableElements = DomUtils.getChildElementsByTagName((Element)encryptTablesElement, (String)"table");
        ManagedMap result = new ManagedMap(encryptTableElements.size());
        for (Element each : encryptTableElements) {
            result.put(each.getAttribute("name"), EncryptRuleBeanDefinitionParser.parseEncryptTableConfiguration(each));
        }
        return result;
    }

    private static AbstractBeanDefinition parseEncryptTableConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptTableRuleConfiguration.class);
        factory.addConstructorArgValue(EncryptRuleBeanDefinitionParser.parseEncryptColumnConfigurations(element));
        return factory.getBeanDefinition();
    }

    private static Map<String, BeanDefinition> parseEncryptColumnConfigurations(Element element) {
        List encryptColumnElements = DomUtils.getChildElementsByTagName((Element)element, (String)"column");
        ManagedMap result = new ManagedMap(encryptColumnElements.size());
        for (Element each : encryptColumnElements) {
            result.put(each.getAttribute("logic-column"), EncryptRuleBeanDefinitionParser.parseEncryptColumnConfiguration(each));
        }
        return result;
    }

    private static AbstractBeanDefinition parseEncryptColumnConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptColumnRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("plain-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("cipher-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("assisted-query-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("encryptor-ref"));
        return factory.getBeanDefinition();
    }

    private EncryptRuleBeanDefinitionParser() {
    }
}

