/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.ingest.position;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;

public final class PrimaryKeyPosition
implements IngestPosition<PrimaryKeyPosition> {
    private final long beginValue;
    private final long endValue;

    public static PrimaryKeyPosition init(String data) {
        String[] array = data.split(",");
        Preconditions.checkArgument((array.length == 2 ? 1 : 0) != 0, (Object)("Unknown primary key position: " + data));
        return new PrimaryKeyPosition(Long.parseLong(array[0]), Long.parseLong(array[1]));
    }

    @Override
    public int compareTo(PrimaryKeyPosition position) {
        if (null == position) {
            return 1;
        }
        return Long.compare(this.beginValue, position.beginValue);
    }

    public String toString() {
        return String.format("%d,%d", this.beginValue, this.endValue);
    }

    @Generated
    public PrimaryKeyPosition(long beginValue, long endValue) {
        this.beginValue = beginValue;
        this.endValue = endValue;
    }

    @Generated
    public long getBeginValue() {
        return this.beginValue;
    }

    @Generated
    public long getEndValue() {
        return this.endValue;
    }
}

