/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;

public final class TableMetaData {
    private final String name;
    private final Map<String, ColumnMetaData> columns;
    private final Map<String, IndexMetaData> indexes;
    private final Map<String, ConstraintMetaData> constrains;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();

    public TableMetaData() {
        this("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public TableMetaData(String name, Collection<ColumnMetaData> columnMetaDataList, Collection<IndexMetaData> indexMetaDataList, Collection<ConstraintMetaData> constraintMetaDataList) {
        this.name = name;
        this.columns = this.getColumns(columnMetaDataList);
        this.indexes = this.getIndexes(indexMetaDataList);
        this.constrains = this.getConstrains(constraintMetaDataList);
    }

    private Map<String, ColumnMetaData> getColumns(Collection<ColumnMetaData> columnMetaDataList) {
        LinkedHashMap<String, ColumnMetaData> result = new LinkedHashMap<String, ColumnMetaData>(columnMetaDataList.size(), 1.0f);
        for (ColumnMetaData each : columnMetaDataList) {
            String lowerColumnName = each.getName().toLowerCase();
            result.put(lowerColumnName, each);
            this.columnNames.add(each.getName());
            if (!each.isPrimaryKey()) continue;
            this.primaryKeyColumns.add(lowerColumnName);
        }
        return result;
    }

    private Map<String, IndexMetaData> getIndexes(Collection<IndexMetaData> indexMetaDataList) {
        LinkedHashMap<String, IndexMetaData> result = new LinkedHashMap<String, IndexMetaData>(indexMetaDataList.size(), 1.0f);
        for (IndexMetaData each : indexMetaDataList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    private Map<String, ConstraintMetaData> getConstrains(Collection<ConstraintMetaData> constraintMetaDataList) {
        LinkedHashMap<String, ConstraintMetaData> result = new LinkedHashMap<String, ConstraintMetaData>(constraintMetaDataList.size(), 1.0f);
        for (ConstraintMetaData each : constraintMetaDataList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, ColumnMetaData> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, IndexMetaData> getIndexes() {
        return this.indexes;
    }

    @Generated
    public Map<String, ConstraintMetaData> getConstrains() {
        return this.constrains;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMetaData)) {
            return false;
        }
        TableMetaData other = (TableMetaData)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, ColumnMetaData> this$columns = this.getColumns();
        Map<String, ColumnMetaData> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, IndexMetaData> this$indexes = this.getIndexes();
        Map<String, IndexMetaData> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        Map<String, ConstraintMetaData> this$constrains = this.getConstrains();
        Map<String, ConstraintMetaData> other$constrains = other.getConstrains();
        if (this$constrains == null ? other$constrains != null : !((Object)this$constrains).equals(other$constrains)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        return !(this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, ColumnMetaData> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, IndexMetaData> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        Map<String, ConstraintMetaData> $constrains = this.getConstrains();
        result = result * 59 + ($constrains == null ? 43 : ((Object)$constrains).hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TableMetaData(name=" + this.getName() + ", columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", constrains=" + this.getConstrains() + ", columnNames=" + this.getColumnNames() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
    }
}

