/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.core.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public class AggregationProjection
implements Projection {
    private final AggregationType type;
    private final String innerExpression;
    private final String alias;
    private final List<AggregationProjection> derivedAggregationProjections = new ArrayList<AggregationProjection>(2);
    private int index = -1;

    @Override
    public final String getExpression() {
        return SQLUtil.getExactlyValue((String)(this.type.name() + this.innerExpression));
    }

    @Override
    public final Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    @Override
    public String getColumnLabel() {
        return (String)this.getAlias().or((Object)this.getExpression());
    }

    @ConstructorProperties(value={"type", "innerExpression", "alias"})
    public AggregationProjection(AggregationType type, String innerExpression, String alias) {
        this.type = type;
        this.innerExpression = innerExpression;
        this.alias = alias;
    }

    public AggregationType getType() {
        return this.type;
    }

    public String getInnerExpression() {
        return this.innerExpression;
    }

    public List<AggregationProjection> getDerivedAggregationProjections() {
        return this.derivedAggregationProjections;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationProjection)) {
            return false;
        }
        AggregationProjection other = (AggregationProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AggregationType this$type = this.getType();
        AggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$innerExpression = this.getInnerExpression();
        String other$innerExpression = other.getInnerExpression();
        if (this$innerExpression == null ? other$innerExpression != null : !this$innerExpression.equals(other$innerExpression)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        List<AggregationProjection> this$derivedAggregationProjections = this.getDerivedAggregationProjections();
        List<AggregationProjection> other$derivedAggregationProjections = other.getDerivedAggregationProjections();
        if (this$derivedAggregationProjections == null ? other$derivedAggregationProjections != null : !((Object)this$derivedAggregationProjections).equals(other$derivedAggregationProjections)) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregationProjection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $innerExpression = this.getInnerExpression();
        result = result * 59 + ($innerExpression == null ? 0 : $innerExpression.hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 0 : $alias.hashCode());
        List<AggregationProjection> $derivedAggregationProjections = this.getDerivedAggregationProjections();
        result = result * 59 + ($derivedAggregationProjections == null ? 0 : ((Object)$derivedAggregationProjections).hashCode());
        result = result * 59 + this.getIndex();
        return result;
    }

    public String toString() {
        return "AggregationProjection(type=" + this.getType() + ", innerExpression=" + this.getInnerExpression() + ", alias=" + this.getAlias() + ", derivedAggregationProjections=" + this.getDerivedAggregationProjections() + ", index=" + this.getIndex() + ")";
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

