/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeReaders;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapData;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeArrayData
extends ArrayData {
    private Object baseObject;
    private long baseOffset;
    private int numElements;
    private int sizeInBytes;

    private int getElementOffset(int ordinal) {
        return Platform.getInt((Object)this.baseObject, (long)(this.baseOffset + (long)ordinal * 4L));
    }

    private int getElementSize(int offset, int ordinal) {
        if (ordinal == this.numElements - 1) {
            return this.sizeInBytes - offset;
        }
        return Math.abs(this.getElementOffset(ordinal + 1)) - offset;
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.numElements) : "ordinal (" + ordinal + ") should < " + this.numElements;
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    public void pointTo(Object baseObject, long baseOffset, int numElements, int sizeInBytes) {
        assert (numElements >= 0) : "numElements (" + numElements + ") should >= 0";
        this.numElements = numElements;
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public boolean isNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getElementOffset(ordinal) < 0;
    }

    @Override
    public Object get(int ordinal, DataType dataType2) {
        if (this.isNullAt(ordinal) || dataType2 instanceof NullType) {
            return null;
        }
        if (dataType2 instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType2 instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType2 instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType2 instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType2 instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType2 instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType2 instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType dt = (DecimalType)dataType2;
            return this.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (dataType2 instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType2 instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType2 instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType2 instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType2 instanceof CalendarIntervalType) {
            return this.getInterval(ordinal);
        }
        if (dataType2 instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType2).size());
        }
        if (dataType2 instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType2 instanceof MapType) {
            return this.getMap(ordinal);
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataType2.simpleString());
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return false;
        }
        return Platform.getBoolean((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0;
        }
        return Platform.getByte((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public short getShort(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0;
        }
        return Platform.getShort((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public int getInt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0;
        }
        return Platform.getInt((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public long getLong(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0L;
        }
        return Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public float getFloat(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0.0f;
        }
        return Platform.getFloat((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public double getDouble(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return 0.0;
        }
        return Platform.getDouble((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            long value = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
            return Decimal.apply(value, precision, scale);
        }
        byte[] bytes = this.getBinary(ordinal);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply(new scala.math.BigDecimal(javaDecimal), precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int size = this.getElementSize(offset, ordinal);
        return UTF8String.fromAddress((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (int)size);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int size = this.getElementSize(offset, ordinal);
        byte[] bytes = new byte[size];
        Platform.copyMemory((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        return bytes;
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int months = (int)Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
        long microseconds = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset + 8L));
        return new CalendarInterval(months, microseconds);
    }

    @Override
    public InternalRow getStruct(int ordinal, int numFields) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int size = this.getElementSize(offset, ordinal);
        UnsafeRow row = new UnsafeRow();
        row.pointTo(this.baseObject, this.baseOffset + (long)offset, numFields, size);
        return row;
    }

    @Override
    public ArrayData getArray(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int size = this.getElementSize(offset, ordinal);
        return UnsafeReaders.readArray(this.baseObject, this.baseOffset + (long)offset, size);
    }

    @Override
    public MapData getMap(int ordinal) {
        this.assertIndexIsValid(ordinal);
        int offset = this.getElementOffset(ordinal);
        if (offset < 0) {
            return null;
        }
        int size = this.getElementSize(offset, ordinal);
        return UnsafeReaders.readMap(this.baseObject, this.baseOffset + (long)offset, size);
    }

    public int hashCode() {
        int result = 37;
        for (int i = 0; i < this.sizeInBytes; ++i) {
            result = 37 * result + Platform.getByte((Object)this.baseObject, (long)(this.baseOffset + (long)i));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof UnsafeArrayData) {
            UnsafeArrayData o = (UnsafeArrayData)other;
            return this.sizeInBytes == o.sizeInBytes && ByteArrayMethods.arrayEquals((Object)this.baseObject, (long)this.baseOffset, (Object)o.baseObject, (long)o.baseOffset, (long)this.sizeInBytes);
        }
        return false;
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)target, (long)targetOffset, (long)this.sizeInBytes);
    }

    @Override
    public UnsafeArrayData copy() {
        UnsafeArrayData arrayCopy = new UnsafeArrayData();
        byte[] arrayDataCopy = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)arrayDataCopy, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        arrayCopy.pointTo(arrayDataCopy, Platform.BYTE_ARRAY_OFFSET, this.numElements, this.sizeInBytes);
        return arrayCopy;
    }
}

