/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelectStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelectStatement;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r\u0015b\u0001B\u001f?\u0005\u001dC\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0007?\u0002!\tA\u00101\t\u000f\r\u0004!\u0019!C\u0005I\"1A\u000e\u0001Q\u0001\n\u0015DQ!\u001c\u0001\u0005\u00029DQ!\u001c\u0001\u0005\u0002QDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u0018!9\u00111\u0002\u0001\u0005\u0002\u0005\r\u0002bBA\u0006\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u001bBq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002|\u0001!\t!! \t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAN\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003W\u0003A\u0011BAU\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!,\u0001\t\u0013\t)\fC\u0004\u0002.\u0002!I!a5\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u0011\u0011 \u0001\u0005\n\u0005m\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u001bAqAa\u0002\u0001\t\u0013\u0011i\u0003C\u0004\u00032\u0001!IAa\r\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!\u0011\n\u0001\u0005\n\t-\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005[\u0002A\u0011\u0001B8\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqA!\u001f\u0001\t\u0003\u0011Y\bC\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"9!1\u0012\u0001\u0005\n\t5\u0005b\u0002BZ\u0001\u0011%!Q\u0017\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0005\u007fC\u0011B!1\u0001\u0001\u0004%IAa1\t\u000f\t%\u0007\u0001)Q\u0005m\"AQ\u000e\u0001a\u0001\n\u0013\u0011Y\rC\u0005\u0003N\u0002\u0001\r\u0011\"\u0003\u0003P\"9!1\u001b\u0001!B\u0013\t\b\"\u0003Bk\u0001\u0001\u0007I\u0011\u0002Bl\u0011%\u0011\u0019\u000f\u0001a\u0001\n\u0013\u0011)\u000f\u0003\u0005\u0003j\u0002\u0001\u000b\u0015\u0002Bm\u0011%\u0011Y\u000f\u0001a\u0001\n\u0013\u0011i\u000fC\u0005\u0003r\u0002\u0001\r\u0011\"\u0003\u0003t\"A!q\u001f\u0001!B\u0013\u0011y\u000fC\u0005\u0003z\u0002\u0001\r\u0011\"\u0003\u0003n\"I!1 \u0001A\u0002\u0013%!Q \u0005\t\u0007\u0003\u0001\u0001\u0015)\u0003\u0003p\"I\u0011\u0011\u0011\u0001A\u0002\u0013%11\u0001\u0005\n\u0007\u000f\u0001\u0001\u0019!C\u0005\u0007\u0013A\u0001b!\u0004\u0001A\u0003&1Q\u0001\u0005\n\u0007\u001f\u0001\u0001\u0019!C\u0005\u0005[D\u0011b!\u0005\u0001\u0001\u0004%Iaa\u0005\t\u0011\r]\u0001\u0001)Q\u0005\u0005_\u0014q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u007f\u0001\u000b1a]9m\u0015\t\t%)A\u0003ta\u0006\u00148N\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<7\u0001A\u000b\u0003\u0011Z\u001b\"\u0001A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\r\u0005s\u0017PU3g\u0003\t!7\u000fE\u0002R%Rk\u0011AP\u0005\u0003'z\u0012q\u0001R1uCN,G\u000f\u0005\u0002V-2\u0001A!B,\u0001\u0005\u0004A&!\u0001+\u0012\u0005ec\u0006C\u0001&[\u0013\tY6JA\u0004O_RD\u0017N\\4\u0011\u0005)k\u0016B\u00010L\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0014\u0007cA)\u0001)\")qJ\u0001a\u0001!\u0006\u0011AMZ\u000b\u0002KB\u0011a-\u001b\b\u0003#\u001eL!\u0001\u001b \u0002\u000fA\f7m[1hK&\u0011!n\u001b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001\u001b \u0002\u0007\u00114\u0007%\u0001\u0003n_\u0012,GCA1p\u0011\u0015\u0001X\u00011\u0001r\u0003!\u0019\u0018M^3N_\u0012,\u0007CA)s\u0013\t\u0019hH\u0001\u0005TCZ,Wj\u001c3f)\t\tW\u000fC\u0003q\r\u0001\u0007a\u000f\u0005\u0002x}:\u0011\u0001\u0010 \t\u0003s.k\u0011A\u001f\u0006\u0003w\u001a\u000ba\u0001\u0010:p_Rt\u0014BA?L\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\rM#(/\u001b8h\u0015\ti8*\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0004C\u0006\u001d\u0001BBA\u0005\u000f\u0001\u0007a/\u0001\u0004t_V\u00148-Z\u0001\u0007_B$\u0018n\u001c8\u0015\u000b\u0005\fy!a\u0005\t\r\u0005E\u0001\u00021\u0001w\u0003\rYW-\u001f\u0005\u0007\u0003+A\u0001\u0019\u0001<\u0002\u000bY\fG.^3\u0015\u000b\u0005\fI\"a\u0007\t\r\u0005E\u0011\u00021\u0001w\u0011\u001d\t)\"\u0003a\u0001\u0003;\u00012ASA\u0010\u0013\r\t\tc\u0013\u0002\b\u0005>|G.Z1o)\u0015\t\u0017QEA\u0014\u0011\u0019\t\tB\u0003a\u0001m\"9\u0011Q\u0003\u0006A\u0002\u0005%\u0002c\u0001&\u0002,%\u0019\u0011QF&\u0003\t1{gn\u001a\u000b\u0006C\u0006E\u00121\u0007\u0005\u0007\u0003#Y\u0001\u0019\u0001<\t\u000f\u0005U1\u00021\u0001\u00026A\u0019!*a\u000e\n\u0007\u0005e2J\u0001\u0004E_V\u0014G.Z\u0001\b_B$\u0018n\u001c8t)\r\t\u0017q\b\u0005\b\u0003wa\u0001\u0019AA!!\u0019\t\u0019%!\u0013wm6\u0011\u0011Q\t\u0006\u0004\u0003\u000fZ\u0015AC2pY2,7\r^5p]&!\u00111JA#\u0005\ri\u0015\r\u001d\u000b\u0004C\u0006=\u0003bBA\u001e\u001b\u0001\u0007\u0011\u0011\u000b\t\u0007\u0003'\niF\u001e<\u000e\u0005\u0005U#\u0002BA,\u00033\nA!\u001e;jY*\u0011\u00111L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005U\u0013a\u00039beRLG/[8o\u0005f$2!YA2\u0011\u001d\t)G\u0004a\u0001\u0003O\n\u0001bY8m\u001d\u0006lWm\u001d\t\u0005\u0015\u0006%d/C\u0002\u0002l-\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rq\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005M$a\u0002<be\u0006\u0014xm]\u0001\tEV\u001c7.\u001a;CsR9\u0011-a \u0002\n\u00065\u0005bBAA\u001f\u0001\u0007\u00111Q\u0001\u000b]Vl')^2lKR\u001c\bc\u0001&\u0002\u0006&\u0019\u0011qQ&\u0003\u0007%sG\u000f\u0003\u0004\u0002\f>\u0001\rA^\u0001\bG>dg*Y7f\u0011\u001d\t)g\u0004a\u0001\u0003OB3aDA8\u0003\u0019\u0019xN\u001d;CsR)\u0011-!&\u0002\u0018\"1\u00111\u0012\tA\u0002YDq!!\u001a\u0011\u0001\u0004\t9\u0007K\u0002\u0011\u0003_\nAa]1wKR!\u0011qTAS!\rQ\u0015\u0011U\u0005\u0004\u0003G[%\u0001B+oSRDa!a*\u0012\u0001\u00041\u0018\u0001\u00029bi\"$\"!a(\u0002\u001dM\fg/\u001a+p-F\u001av.\u001e:dK\u0006Q\u0011N\\:feRLe\u000e^8\u0015\t\u0005}\u0015\u0011\u0017\u0005\u0007\u0003g#\u0002\u0019\u0001<\u0002\u0013Q\f'\r\\3OC6,GCBAP\u0003o\u000bI\rC\u0004\u0002:V\u0001\r!a/\u0002\u000f\r\fG/\u00197pOB!\u0011QXAc\u001b\t\tyL\u0003\u0003\u0002:\u0006\u0005'bAAb}\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003\u000f\fyLA\u0007DCR\fGn\\4QYV<\u0017N\u001c\u0005\b\u0003\u0017,\u0002\u0019AAg\u0003\u0015IG-\u001a8u!\u0011\ti,a4\n\t\u0005E\u0017q\u0018\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014H\u0003BAP\u0003+Dq!a6\u0017\u0001\u0004\tI.\u0001\u0006uC\ndW-\u00133f]R\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?t\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\r\u0018Q\u001c\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006iq-\u001a;Ck\u000e\\W\r^*qK\u000e,\"!!;\u0011\u000b)\u000bY/a<\n\u0007\u000558J\u0001\u0004PaRLwN\u001c\t\u0005\u0003c\f)0\u0004\u0002\u0002t*!\u0011\u0011XAo\u0013\u0011\t90a=\u0003\u0015\t+8m[3u'B,7-A\tbgN,'\u000f\u001e(pi\n+8m[3uK\u0012$B!a(\u0002~\"1\u0011q \rA\u0002Y\f\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002)\u0005\u001c8/\u001a:u\u001d>$\b+\u0019:uSRLwN\\3e)\u0011\tyJ!\u0002\t\r\u0005}\u0018\u00041\u0001w\u0003-\u0019\u0018M^3BgR\u000b'\r\\3\u0015\t\u0005}%1\u0002\u0005\u0007\u0003gS\u0002\u0019\u0001<\u0015\u0011\u0005}%q\u0002B\f\u00053Aq!!/\u001c\u0001\u0004\u0011\t\u0002\u0005\u0003\u0002>\nM\u0011\u0002\u0002B\u000b\u0003\u007f\u0013A\u0002V1cY\u0016\u001c\u0015\r^1m_\u001eDq!a3\u001c\u0001\u0004\ti\rC\u0004\u0003\u001cm\u0001\rA!\b\u0002\u00139\fW.\u001a)beR\u001c\b#\u0002B\u0010\u0005O1h\u0002\u0002B\u0011\u0005Kq1!\u001fB\u0012\u0013\u0005a\u0015B\u00015L\u0013\u0011\u0011ICa\u000b\u0003\u0007M+\u0017O\u0003\u0002i\u0017R!\u0011q\u0014B\u0018\u0011\u001d\t9\u000e\ba\u0001\u00033\f1b\u0019:fCR,G+\u00192mKR!\u0011q\u0014B\u001b\u0011\u001d\t9.\ba\u0001\u00033\f\u0001\u0003]1si&$\u0018n\u001c8j]\u001e\f5O\u0016\u001a\u0016\u0005\tm\u0002C\u0002B\u0010\u0005O\u0011i\u0004\u0005\u0003\u0003@\t\u0015SB\u0001B!\u0015\u0011\u0011\u0019%!1\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005\u000f\u0012\tEA\u0005Ue\u0006t7OZ8s[\u0006y2\r[3dWB\u000b'\u000f^5uS>t\u0017N\\4NCR\u001c\u0007.Z:WeQ\u000b'\r\\3\u0015\t\u0005}%Q\n\u0005\b\u0005\u001fz\u0002\u0019\u0001B)\u00035)\u00070[:uS:<G+\u00192mKB!\u0011Q\u0018B*\u0013\u0011\u0011)&a0\u0003\u000bQ\u000b'\r\\3\u0002\t)$'m\u0019\u000b\t\u0003?\u0013YFa\u0018\u0003d!1!Q\f\u0011A\u0002Y\f1!\u001e:m\u0011\u0019\u0011\t\u0007\ta\u0001m\u0006)A/\u00192mK\"9!Q\r\u0011A\u0002\t\u001d\u0014\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002T\t%\u0014\u0002\u0002B6\u0003+\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0011Q7o\u001c8\u0015\t\u0005}%\u0011\u000f\u0005\u0007\u0003O\u000b\u0003\u0019\u0001<\u0002\u000fA\f'/];fiR!\u0011q\u0014B<\u0011\u0019\t9K\ta\u0001m\u0006\u0019qN]2\u0015\t\u0005}%Q\u0010\u0005\u0007\u0003O\u001b\u0003\u0019\u0001<\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003?\u0013\u0019\t\u0003\u0004\u0002(\u0012\u0002\rA^\u0001\u0004GN4H\u0003BAP\u0005\u0013Ca!a*&\u0001\u00041\u0018A\u0003:v]\u000e{W.\\1oIR1!q\u0012BS\u0005_#B!a(\u0003\u0012\"9!1\u0013\u0014A\u0002\tU\u0015aB2p[6\fg\u000e\u001a\t\u0005\u0005/\u0013\t+\u0004\u0002\u0003\u001a*!!1\u0014BO\u0003\u001dawnZ5dC2TAAa(\u0002^\u0006)\u0001\u000f\\1og&!!1\u0015BM\u0005-aunZ5dC2\u0004F.\u00198\t\u000f\t\u001df\u00051\u0001\u0003*\u000691/Z:tS>t\u0007cA)\u0003,&\u0019!Q\u0016 \u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\r\tEf\u00051\u0001w\u0003\u0011q\u0017-\\3\u0002!1|wn[;q-J\u0002&o\u001c<jI\u0016\u0014HC\u0001B\\!\u0015Q\u00151\u001eB]!\u0011\tiLa/\n\t\tu\u0016q\u0018\u0002\u000e)\u0006\u0014G.\u001a)s_ZLG-\u001a:\u0016\u0003Y\f!b]8ve\u000e,w\fJ3r)\u0011\tyJ!2\t\u0011\t\u001d\u0017&!AA\u0002Y\f1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002*\u0012!]\u0001\t[>$Wm\u0018\u0013fcR!\u0011q\u0014Bi\u0011!\u00119\rLA\u0001\u0002\u0004\t\u0018!B7pI\u0016\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001Bm!\u0015\u0011YNa8w\u001b\t\u0011iN\u0003\u0003\u0002X\u0005u\u0017\u0002\u0002Bq\u0005;\u0014!cQ1tK&s7/\u001a8tSRLg/Z'ba\u0006\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0003?\u00139\u000fC\u0005\u0003H>\n\t\u00111\u0001\u0003Z\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N,\"Aa<\u0011\u000b)\u000bYO!\b\u0002/A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:`I\u0015\fH\u0003BAP\u0005kD\u0011Ba23\u0003\u0003\u0005\rAa<\u0002)A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:!\u0003E\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm]\u0001\u0016EV\u001c7.\u001a;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\tyJa@\t\u0013\t\u001dW'!AA\u0002\t=\u0018A\u00052vG.,GoQ8mk6tg*Y7fg\u0002*\"a!\u0002\u0011\u000b)\u000bY/a!\u0002\u001d9,XNQ;dW\u0016$8o\u0018\u0013fcR!\u0011qTB\u0006\u0011%\u00119\rOA\u0001\u0002\u0004\u0019)!A\u0006ok6\u0014UoY6fiN\u0004\u0013aD:peR\u001cu\u000e\\;n]:\u000bW.Z:\u0002'M|'\u000f^\"pYVlgNT1nKN|F%Z9\u0015\t\u0005}5Q\u0003\u0005\n\u0005\u000f\\\u0014\u0011!a\u0001\u0005_\f\u0001c]8si\u000e{G.^7o\u001d\u0006lWm\u001d\u0011)\u0007\u0001\u0019Y\u0002\u0005\u0003\u0004\u001e\r\u0005RBAB\u0010\u0015\r\t)\bQ\u0005\u0005\u0007G\u0019yB\u0001\u0004Ti\u0006\u0014G.\u001a")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        DataFrameWriter<T> dataFrameWriter;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Overwrite);
        } else if ("append".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Append);
        } else if ("ignore".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Ignore);
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                dataFrameWriter = this.mode(SaveMode.ErrorIfExists);
            } else {
                throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
            }
        }
        return dataFrameWriter;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$save$1(this, x$3))).$plus$plus((GenTraversableOnce)this.extraOptions().toMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            boolean bl = ((Object)((Object)SaveMode.Append)).equals((Object)saveMode) ? true : ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode);
            if (bl) {
                BoxedUnit boxedUnit;
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else if (tableProvider != null) {
                    Table t = this.getTable$1(provider, dsOptions);
                    if (!DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        this.saveToV1Source();
                        return;
                    }
                    tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Tuple3 tuple34 = tuple33;
                Table table2 = (Table)tuple34._1();
                Option catalog2 = (Option)tuple34._2();
                Option ident2 = (Option)tuple34._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), this.extraOptions().toMap()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    Option location = Option$.MODULE$.apply((Object)dsOptions.get((Object)"path")).map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$5));
                    SaveMode saveMode4 = saveMode;
                    SaveMode saveMode5 = SaveMode.Ignore;
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)new CreateTableAsSelect(catalog, ident, this.partitioningAsV2(), this.df().queryExecution().analyzed(), ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.source())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(location)), this.extraOptions().toMap(), !(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (tableProvider != null) {
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                        throw new AnalysisException(new StringBuilder(105).append("TableProvider implementation ").append(this.source()).append(" cannot be ").append("written with ").append((Object)saveMode).append(" mode, please use Append or Overwrite ").append("modes instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    this.saveToV1Source();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> {
            this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertInto(String tableName) {
        Option option;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.insertInto(catalog, ident);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.insertInto(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = var5_4 = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_6 = this.mode();
                    var4_7 = SaveMode.Append.equals((Object)var9_6) != false ? true : (SaveMode.ErrorIfExists.equals((Object)var9_6) != false ? true : SaveMode.Ignore.equals((Object)var9_6) != false);
                    if (!var4_7) break block3;
                    var3_8 = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals((Object)var9_6)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v0 = conf.partitionOverwriteMode();
                var12_10 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v0 != null ? v0.equals(var12_10) == false : var12_10 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                dynamicPartitionOverwrite = v1;
                var3_8 = dynamicPartitionOverwrite != false ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_6);
        }
        command = var3_8;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveAsTable(String tableName) {
        Option option;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.saveAsTable(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals((Object)var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            var4_13 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals((Object)(var15_14 = (SaveMode)var7_5._1()))) {
            var4_13 = new ReplaceTableAsSelectStatement(nameParts, this.df().queryExecution().analyzed(), this.partitioningAsV2(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), this.extraOptions().toMap(), true);
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            v2 = other;
            var17_16 = SaveMode.Ignore;
            var4_13 = new CreateTableAsSelectStatement(nameParts, this.df().queryExecution().analyzed(), this.partitioningAsV2(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), this.extraOptions().toMap(), !(v2 != null ? v2.equals((Object)var17_16) == false : var17_16 != null));
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = var4_13;
        this.runCommand(this.df().sparkSession(), "saveAsTable", (LogicalPlan)command);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable & scala.Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("The provided partitioning does not match of the table.\n").append(" - provided: ").append(v2Partitions.mkString(", ")).append("\n").append(" - table: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingTable.partitioning())).mkString(", ")).toString());
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table)}))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)name), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        None$ none$ = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        None$ none$2 = none$ instanceof Some && (some = (Some)none$).value() instanceof FileDataSourceV2 ? None$.MODULE$ : none$;
        return none$2;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$save$1(DataFrameWriter $this, String x$3) {
        return !$this.extraOptions().contains(x$3);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        return provider$1 instanceof FileDataSourceV2 ? provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap()) : DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

