/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.dilithium;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumSigner;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPublicKey;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private DilithiumSigner signer;
    private SecureRandom random;

    protected SignatureSpi(DilithiumSigner dilithiumSigner) {
        super("Dilithium");
        this.signer = dilithiumSigner;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCDilithiumPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to Dilithium");
        }
        BCDilithiumPublicKey bCDilithiumPublicKey = (BCDilithiumPublicKey)publicKey;
        DilithiumPublicKeyParameters dilithiumPublicKeyParameters = bCDilithiumPublicKey.getKeyParams();
        this.signer.init(false, dilithiumPublicKeyParameters);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCDilithiumPrivateKey) {
            BCDilithiumPrivateKey bCDilithiumPrivateKey = (BCDilithiumPrivateKey)privateKey;
            DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters = bCDilithiumPrivateKey.getKeyParams();
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(dilithiumPrivateKeyParameters, this.random));
            } else {
                this.signer.init(true, dilithiumPrivateKeyParameters);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Dilithium");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.bOut.write(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bOut.write(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(byArray2, byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Base
    extends SignatureSpi {
        public Base() throws NoSuchAlgorithmException {
            super(new DilithiumSigner());
        }
    }
}

