/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.studio;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Optional;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.state.StateSnapshot;
import org.bsc.langgraph4j.studio.LangGraphStreamingServer;
import org.slf4j.Logger;

class NodeOutputSerializer
extends StdSerializer<NodeOutput> {
    Logger log = LangGraphStreamingServer.log;

    protected NodeOutputSerializer() {
        super(NodeOutput.class);
    }

    public void serialize(NodeOutput nodeOutput, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        StateSnapshot snapshot;
        this.log.trace("NodeOutputSerializer start! {}", nodeOutput.getClass());
        gen.writeStartObject();
        if (nodeOutput instanceof StateSnapshot) {
            snapshot = (StateSnapshot)nodeOutput;
            Optional checkpoint = snapshot.config().checkPointId();
            this.log.trace("checkpoint: {}", (Object)checkpoint);
            if (checkpoint.isPresent()) {
                gen.writeStringField("checkpoint", (String)checkpoint.get());
            }
        }
        if (nodeOutput.isSubGraph()) {
            gen.writeStringField("node", "_" + nodeOutput.node());
        } else {
            gen.writeStringField("node", nodeOutput.node());
        }
        gen.writeObjectField("state", (Object)nodeOutput.state().data());
        if (nodeOutput instanceof StateSnapshot) {
            snapshot = (StateSnapshot)nodeOutput;
            gen.writeObjectField("next", (Object)snapshot.next());
        }
        gen.writeEndObject();
    }
}

