/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.security.wss4j;

import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.security.wss4j.AbstractWSS4JHandler;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.dom.DOMOutHandler;
import org.w3c.dom.Document;

public class WSS4JOutHandler
extends AbstractWSS4JHandler {
    protected static Log log = LogFactory.getLog((String)WSS4JOutHandler.class.getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");

    public WSS4JOutHandler() {
        this.setPhase("user");
        this.getAfter().add(DOMOutHandler.class.getName());
    }

    public WSS4JOutHandler(Map props) {
        this();
        this.setProperties(props);
    }

    public void invoke(MessageContext mc) throws Exception {
        boolean doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (doDebug) {
            log.debug((Object)"WSDoAllSender: enter invoke()");
        }
        RequestData reqData = new RequestData();
        reqData.setMsgContext((Object)mc);
        try {
            String username;
            Vector actions = new Vector();
            String action = this.getString("action", mc);
            if (action == null) {
                throw new XFireRuntimeException("WSDoAllSender: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            if (doAction == 0) {
                return;
            }
            reqData.setUsername((String)this.getOption("user"));
            if ((reqData.getUsername() == null || reqData.getUsername().equals("")) && (username = (String)this.getProperty(reqData.getMsgContext(), "user")) != null) {
                reqData.setUsername(username);
            }
            if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
                throw new XFireFault("WSDoAllSender: Empty username for specified action", XFireFault.RECEIVER);
            }
            if (doDebug) {
                log.debug((Object)("Action: " + doAction));
                log.debug((Object)("Actor: " + reqData.getActor()));
            }
            OutMessage message = (OutMessage)mc.getCurrentMessage();
            Document doc = (Document)message.getProperty((Object)"dom.message");
            if (message == null) {
                return;
            }
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            this.doSenderAction(doAction, doc, reqData, actions, AbstractBinding.isClientModeOn((MessageContext)mc));
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            if (tlog.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
                tlog.debug((Object)("Send request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " request to Axis= " + (t3 - t2) + "\n"));
            }
            if (doDebug) {
                log.debug((Object)"WSDoAllSender: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new XFireFault(e.getMessage(), (Throwable)e, XFireFault.RECEIVER);
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }
}

