/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.limit.Sort;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.util.HtmlBuilder;

public class FormBuilder {
    private HtmlBuilder html;
    private TableModel model;

    public FormBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public FormBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void formStart() {
        this.formAttributes();
        this.html.newline();
        this.html.div().close();
        this.instanceParameter();
        this.exportTableIdParameter();
        this.exportParameters();
        this.rowsDisplayedParameter();
        this.filterParameter();
        this.pageParameters();
        this.sortParameters();
        this.aliasParameters();
        this.userDefinedParameters();
        this.html.newline();
        this.html.divEnd();
    }

    public void formEnd() {
        String form = this.model.getTableHandler().getTable().getForm();
        if (StringUtils.isBlank((String)form)) {
            this.html.formEnd();
        }
    }

    public void formAttributes() {
        String form = this.model.getTableHandler().getTable().getForm();
        if (StringUtils.isBlank((String)form)) {
            this.html.form();
            this.html.id(this.model.getTableHandler().getTable().getTableId());
            this.html.action(this.model.getTableHandler().getTable().getAction());
            this.html.method(this.model.getTableHandler().getTable().getMethod());
            this.html.close();
        }
    }

    public void instanceParameter() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name("ec_i");
        this.html.value(this.model.getTableHandler().getTable().getTableId());
        this.html.xclose();
    }

    public void filterParameter() {
        if (BuilderUtils.filterable(this.model)) {
            this.html.newline();
            this.html.input("hidden");
            this.html.name(this.model.getTableHandler().prefixWithTableId() + "f_" + "a");
            if (this.model.getLimit().isFiltered()) {
                this.html.value("fa");
            }
            this.html.xclose();
        }
    }

    public void rowsDisplayedParameter() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name(this.model.getTableHandler().prefixWithTableId() + "crd");
        int currentRowsDisplayed = this.model.getLimit().getCurrentRowsDisplayed();
        this.html.value(String.valueOf(currentRowsDisplayed));
        this.html.xclose();
    }

    public void pageParameters() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name(this.model.getTableHandler().prefixWithTableId() + "p");
        int page = this.model.getLimit().getPage();
        if (page > 0) {
            this.html.value(String.valueOf(page));
        }
        this.html.xclose();
    }

    public void exportTableIdParameter() {
        String existingForm;
        if (!BuilderUtils.showExports(this.model)) {
            return;
        }
        String form = BuilderUtils.getForm(this.model);
        if (form.equals(existingForm = (String)this.model.getContext().getRequestAttribute("ec_eti"))) {
            return;
        }
        this.html.newline();
        this.html.input("hidden");
        this.html.name("ec_eti");
        this.html.xclose();
        this.model.getContext().setRequestAttribute("ec_eti", form);
    }

    public void exportParameters() {
        if (!BuilderUtils.showExports(this.model)) {
            return;
        }
        this.html.newline();
        this.html.input("hidden");
        this.html.name(this.model.getTableHandler().prefixWithTableId() + "ev");
        this.html.xclose();
        this.html.newline();
        this.html.input("hidden");
        this.html.name(this.model.getTableHandler().prefixWithTableId() + "efn");
        this.html.xclose();
    }

    public void sortParameters() {
        List columns = this.model.getColumnHandler().getColumns();
        for (Column column : columns) {
            if (!column.isSortable()) continue;
            this.html.newline();
            this.html.input("hidden");
            this.html.name(this.model.getTableHandler().prefixWithTableId() + "s_" + column.getAlias());
            Sort sort = this.model.getLimit().getSort();
            if (sort.isSorted() && sort.getAlias().equals(column.getAlias())) {
                this.html.value(sort.getSortOrder());
            }
            this.html.xclose();
        }
    }

    public void userDefinedParameters() {
        Map parameterMap = this.model.getRegistry().getParameterMap();
        Set keys = parameterMap.keySet();
        for (String name : keys) {
            if (name.startsWith(this.model.getTableHandler().prefixWithTableId())) continue;
            String[] values = (String[])parameterMap.get(name);
            if (values == null || values.length == 0) {
                this.html.newline();
                this.html.input("hidden").name(name).xclose();
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                this.html.newline();
                this.html.input("hidden").name(name).value(values[i]).xclose();
            }
        }
    }

    public void aliasParameters() {
        List columns = this.model.getColumnHandler().getColumns();
        for (Column column : columns) {
            if (!StringUtils.isNotBlank((String)column.getProperty()) || column.getProperty().equals(column.getAlias())) continue;
            this.html.newline();
            this.html.input("hidden");
            this.html.name(this.model.getTableHandler().prefixWithTableId() + "a_" + column.getAlias());
            this.html.value(column.getProperty());
            this.html.xclose();
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

