/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.HtmlBuilder;

public abstract class TwoColumnTableLayout {
    private HtmlBuilder html;
    private TableModel model;

    public TwoColumnTableLayout(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
    }

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void layout() {
        if (!this.showLayout(this.model)) {
            return;
        }
        this.html.table(0).border("0").cellPadding("0").cellSpacing("0");
        Table table = this.model.getTableHandler().getTable();
        this.html.width(table.getWidth()).close();
        this.html.tr(1).close();
        this.columnLeft(this.html, this.model);
        this.columnRight(this.html, this.model);
        this.html.trEnd(1);
        this.html.tableEnd(0);
        this.html.newline();
    }

    public String toString() {
        return this.html.toString();
    }

    protected abstract boolean showLayout(TableModel var1);

    protected abstract void columnLeft(HtmlBuilder var1, TableModel var2);

    protected abstract void columnRight(HtmlBuilder var1, TableModel var2);
}

