/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.tree.HtmlView;
import org.extremecomponents.tree.HtmlViewUtils;

public final class TreeView
extends HtmlView {
    public void beforeBody(TableModel model) {
        this.div().styleClass("eXtremeTable").close();
        this.titleRow(model);
        this.tableStart(model);
        this.statusBar(model);
        this.filter(model);
        this.header(model);
    }

    public Object afterBody(TableModel model) {
        this.totals(model);
        this.tableEnd(model);
        this.newline().divEnd();
        return this.toString();
    }

    public void titleRow(TableModel model) {
        if (StringUtils.isBlank((String)model.getTableHandler().getTable().getTitle())) {
            return;
        }
        this.table(0).border("0").cellPadding("0").cellSpacing("0");
        this.width(model.getTableHandler().getTable().getWidth()).close();
        this.tr(1).close();
        this.td(2).styleClass("title").close();
        this.title(model);
        this.tdEnd();
        this.trEnd(1);
        this.tableEnd(0);
        this.newline();
    }

    public void statusBar(TableModel model) {
        if (!model.getTableHandler().getTable().isShowStatusBar() && !model.getTableHandler().getTable().isFilterable()) {
            return;
        }
        this.tr(1).close();
        this.td(2).colSpan(String.valueOf(model.getColumnHandler().columnCount())).close();
        this.table(2).border("0").cellPadding("0").cellSpacing("0").width("100%").close();
        this.tr(3).close();
        if (model.getTableHandler().getTable().isShowStatusBar()) {
            this.td(4).styleClass("statusBar").close();
            String count = model.getTableHandler().getTable().getAttributeAsString("FILTERED_COUNT");
            if ("0".equalsIgnoreCase(count)) {
                this.append("\u6ca1\u6709\u627e\u5230\u8bb0\u5f55");
            } else {
                this.append("\u5171\u627e\u5230 " + count + " \u6761\u8bb0\u5f55");
            }
            this.tdEnd();
        }
        if (model.getTableHandler().getTable().isFilterable()) {
            this.td(4).styleClass("filterButtons").close();
            String imageSearchArrow = BuilderUtils.getImage(model, "searchArrow");
            this.img(imageSearchArrow, "Search");
            this.nbsp();
            this.a().quote().append(HtmlViewUtils.filterJavaScript(model)).quote().close();
            String imageSearch = BuilderUtils.getImage(model, "search");
            if (StringUtils.isNotEmpty((String)imageSearch)) {
                this.img(imageSearch, "Search");
            } else {
                this.append("&nbsp;Filter&nbsp;");
            }
            this.aEnd();
            this.nbsp();
            this.a().quote().append("javascript:document.forms." + model.getTableHandler().prefixWithTableId() + "filter." + model.getTableHandler().prefixWithTableId() + "f_" + "a" + ".value='" + "ca" + "';document.forms." + model.getTableHandler().prefixWithTableId() + "filter.submit()").quote().close();
            String imageClear = BuilderUtils.getImage(model, "clear");
            if (StringUtils.isNotEmpty((String)imageClear)) {
                this.img(imageClear, "Clear");
            } else {
                this.append("&nbsp;Clear&nbsp;");
            }
            this.aEnd();
            this.tdEnd();
        }
        this.trEnd(3);
        this.tableEnd(2);
        this.newline();
        this.tabs(2);
        this.tdEnd();
        this.trEnd(1);
        this.tabs(2);
        this.newline();
    }
}

