/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemVariableAggregator;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceState;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.behavior.OnParentEndDependantActivityBehavior;
import org.flowable.cmmn.engine.impl.delegate.BaseVariableAggregatorContext;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.engine.impl.variable.CmmnAggregation;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.SignalEventListener;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.cmmn.model.VariableAggregationDefinitions;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public abstract class AbstractMovePlanItemInstanceToTerminalStateOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public AbstractMovePlanItemInstanceToTerminalStateOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        boolean shouldAggregate;
        String originalState = this.planItemInstanceEntity.getState();
        super.run();
        VariableAggregationDefinitions aggregations = this.getVariableAggregations();
        boolean bl = shouldAggregate = aggregations != null && PlanItemInstanceState.ACTIVE_STATES.contains(originalState);
        if (shouldAggregate && this.shouldAggregateForSingleInstance()) {
            this.aggregateVariablesForSingleInstance(this.planItemInstanceEntity, aggregations);
        }
        if (!this.isNoop) {
            String plannedNewState = this.getNewState();
            boolean isRepeatingOnDelete = this.isRepeatingOnDelete(originalState, plannedNewState);
            boolean isWaitingForRepetitionPlanItemInstanceExists = this.isWaitingForRepetitionPlanItemInstanceExists(this.planItemInstanceEntity);
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(this.commandContext);
            if (isRepeatingOnDelete && !isWaitingForRepetitionPlanItemInstanceExists) {
                if (this.planItemInstanceEntity.getPlanItem() == null || this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof TimerEventListener || !(this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof EventListener)) {
                    PlanItemDefinition planItemDefinition = this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
                    PlanItemInstanceEntity newPlanItemInstanceEntity = PlanItemInstanceUtil.copyAndInsertPlanItemInstance(this.commandContext, this.planItemInstanceEntity, true, false);
                    if (this.planItemInstanceEntity.getPlanItem() != null && (planItemDefinition instanceof TimerEventListener || planItemDefinition instanceof ReactivateEventListener)) {
                        CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(newPlanItemInstanceEntity);
                    } else {
                        String oldState = newPlanItemInstanceEntity.getState();
                        String newState = "wait_repetition";
                        newPlanItemInstanceEntity.setState(newState);
                        cmmnEngineConfiguration.getListenerNotificationHelper().executeLifecycleListeners(this.commandContext, newPlanItemInstanceEntity, oldState, newState);
                        agenda.planCreatePlanItemInstanceForRepetitionOperation(newPlanItemInstanceEntity);
                        if (this.hasRepetitionRuleAndNoEntryCriteria(this.planItemInstanceEntity.getPlanItem())) {
                            agenda.planActivatePlanItemInstanceOperation(newPlanItemInstanceEntity, null);
                        }
                    }
                }
            } else if (shouldAggregate) {
                this.aggregateVariablesForAllInstances(this.planItemInstanceEntity, aggregations);
            }
            this.cleanupRepetitionPlanItemInstances(isRepeatingOnDelete, isWaitingForRepetitionPlanItemInstanceExists, cmmnEngineConfiguration);
            this.removeSentryRelatedData();
        }
    }

    protected VariableAggregationDefinitions getVariableAggregations() {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(this.planItemInstanceEntity);
        return repetitionRule != null ? repetitionRule.getAggregations() : null;
    }

    protected String resolveEventDefinitionKey(String eventType, PlanItemInstanceEntity planItemInstanceEntity, CmmnEngineConfiguration cmmnEngineConfiguration) {
        Object key = cmmnEngineConfiguration.getExpressionManager().createExpression(eventType).getValue((VariableContainer)planItemInstanceEntity);
        if (key == null) {
            throw new FlowableException("Could not resolve key from expression: " + eventType);
        }
        return key.toString();
    }

    @Override
    protected abstract void internalExecute();

    protected void cleanupRepetitionPlanItemInstances(boolean isRepeatingOnDelete, boolean isWaitingForRepetitionPlanItemInstanceExists, CmmnEngineConfiguration cmmnEngineConfiguration) {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        PlanItemDefinition planItemDefinition = this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
        if (!(planItem == null || !(planItemDefinition instanceof EventListener) || planItemDefinition instanceof TimerEventListener || planItemDefinition instanceof ReactivateEventListener || (isRepeatingOnDelete || isWaitingForRepetitionPlanItemInstanceExists || this.hasRepetitionOnCollection(planItem)) && this.hasRepetitionRule(planItem))) {
            List<PlanItemInstanceEntity> planItemInstances = cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByCaseInstanceIdAndPlanItemId(this.planItemInstanceEntity.getCaseInstanceId(), planItem.getId());
            for (PlanItemInstanceEntity planItemInstanceEntry : planItemInstances) {
                if (PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntry)) continue;
                planItemInstanceEntry.setState("completed");
                planItemInstanceEntry.setEndedTime(this.getCurrentTime(this.commandContext));
                planItemInstanceEntry.setCompletedTime(planItemInstanceEntry.getEndedTime());
                CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceCompleted(planItemInstanceEntry);
                cmmnEngineConfiguration.getListenerNotificationHelper().executeLifecycleListeners(this.commandContext, planItemInstanceEntry, "available", "completed");
                if (planItemDefinition instanceof GenericEventListener) {
                    GenericEventListener genericEventListener = (GenericEventListener)planItemDefinition;
                    if (!StringUtils.isNotEmpty((CharSequence)genericEventListener.getEventType())) continue;
                    EventSubscriptionService eventSubscriptionService = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
                    String eventDefinitionKey = this.resolveEventDefinitionKey(genericEventListener.getEventType(), planItemInstanceEntry, cmmnEngineConfiguration);
                    List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstanceEntry.getId());
                    for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                        if (!Objects.equals(eventDefinitionKey, eventSubscription.getEventType())) continue;
                        eventSubscriptionService.deleteEventSubscription(eventSubscription);
                    }
                    continue;
                }
                if (!(planItemDefinition instanceof SignalEventListener)) continue;
                EventSubscriptionService eventSubscriptionService = cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
                List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsBySubScopeId(planItemInstanceEntry.getId());
                for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                    eventSubscriptionService.deleteEventSubscription(eventSubscription);
                }
            }
        }
    }

    public boolean isRepeatingOnDelete(String originalState, String newState) {
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(this.planItemInstanceEntity.getCaseInstanceId());
        if (CaseInstanceState.isInTerminalState((CaseInstance)caseInstance)) {
            return false;
        }
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        if (this.isEvaluateRepetitionRule() && this.hasRepetitionRuleAndNoEntryCriteria(planItem)) {
            return ExpressionUtil.evaluateRepetitionRule(this.commandContext, this.planItemInstanceEntity, this.planItemInstanceEntity.getStagePlanItemInstanceEntity());
        }
        return "available".equals(originalState) && "terminated".equals(newState) && this.hasRepetitionRuleEntryCriteria(planItem) && !this.hasRepetitionOnCollection(planItem) && this.isWithoutStageOrParentIsNotTerminated(this.planItemInstanceEntity);
    }

    public boolean isWithoutStageOrParentIsNotTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getStagePlanItemInstanceEntity() == null || !PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntity.getStagePlanItemInstanceEntity());
    }

    public boolean hasRepetitionRuleAndNoEntryCriteria(PlanItem planItem) {
        return planItem != null && planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null && !planItem.getItemControl().getRepetitionRule().hasCollectionVariable();
    }

    public boolean hasRepetitionOnCollection(PlanItem planItem) {
        return planItem != null && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null && planItem.getItemControl().getRepetitionRule().hasCollectionVariable();
    }

    public boolean hasRepetitionRuleEntryCriteria(PlanItem planItem) {
        return planItem != null && !planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    public boolean hasRepetitionRule(PlanItem planItem) {
        return planItem != null && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    public boolean isWaitingForRepetitionPlanItemInstanceExists(PlanItemInstanceEntity planItemInstanceEntity) {
        List childPlanItemInstances;
        PlanItemInstanceEntity stagePlanItemInstanceEntity = planItemInstanceEntity.getStagePlanItemInstanceEntity();
        if (stagePlanItemInstanceEntity != null && (childPlanItemInstances = stagePlanItemInstanceEntity.getChildPlanItemInstances()) != null && !childPlanItemInstances.isEmpty()) {
            return childPlanItemInstances.stream().anyMatch(p -> Objects.equals(p.getPlanItem().getId(), planItemInstanceEntity.getPlanItem().getId()) && "wait_repetition".equals(p.getState()));
        }
        return false;
    }

    protected void exitChildPlanItemInstances(String parentTransition, String exitCriterionId, String exitEventType) {
        for (PlanItemInstanceEntity child : this.planItemInstanceEntity.getChildPlanItemInstances()) {
            Object behavior = child.getPlanItem().getBehavior();
            if (behavior instanceof OnParentEndDependantActivityBehavior) {
                ((OnParentEndDependantActivityBehavior)behavior).onParentEnd(this.commandContext, child, parentTransition, exitEventType);
                continue;
            }
            if (!StateTransition.isPossible((PlanItemInstance)child, "exit")) continue;
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(child, exitCriterionId, null, null);
        }
    }

    protected void aggregateVariablesForSingleInstance(PlanItemInstanceEntity planItemInstanceEntity, VariableAggregationDefinitions aggregations) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        VariableServiceConfiguration variableServiceConfiguration = cmmnEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        for (VariableAggregationDefinition aggregation : aggregations.getAggregations()) {
            VariableInstanceEntity aggregatedVarInstance = CmmnAggregation.aggregateComplete(planItemInstanceEntity, aggregation, cmmnEngineConfiguration);
            if (aggregatedVarInstance == null) continue;
            variableService.insertVariableInstance(aggregatedVarInstance);
            String targetVarName = aggregatedVarInstance.getName();
            int repetitionCounter = PlanItemInstanceUtil.getRepetitionCounter(planItemInstanceEntity);
            String repetitionValue = aggregatedVarInstance.getId() + "###" + repetitionCounter;
            VariableInstanceEntity counterVarInstance = CmmnAggregation.createScopedVariableAggregationVariableInstance("__flowableCounter__" + targetVarName, aggregatedVarInstance.getScopeId(), aggregatedVarInstance.getSubScopeId(), repetitionValue, variableServiceConfiguration);
            variableService.insertVariableInstance(counterVarInstance);
        }
    }

    protected void aggregateVariablesForAllInstances(PlanItemInstanceEntity planItemInstanceEntity, VariableAggregationDefinitions aggregations) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        List<PlanItemInstanceEntity> planItemInstances = StringUtils.isNotEmpty((CharSequence)planItemInstanceEntity.getStageInstanceId()) ? cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByStageInstanceIdAndPlanItemId(planItemInstanceEntity.getStageInstanceId(), planItemInstanceEntity.getPlanItem().getId()) : cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByCaseInstanceIdAndPlanItemId(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getPlanItem().getId());
        if (planItemInstances == null || planItemInstances.isEmpty()) {
            return;
        }
        for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
            if (PlanItemInstanceState.TERMINAL_STATES.contains(planItemInstance.getState())) continue;
            return;
        }
        String subScopeId = planItemInstanceEntity.getStageInstanceId();
        if (subScopeId == null) {
            subScopeId = planItemInstanceEntity.getCaseInstanceId();
        }
        VariableService variableService = cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List variableInstances = variableService.createInternalVariableInstanceQuery().subScopeId(subScopeId).scopeType("cmmnVariableAggregation").list();
        Map<String, VariableAggregationDefinition> aggregationsByTarget = CmmnAggregation.groupAggregationsByTarget(planItemInstanceEntity, aggregations.getAggregations(), cmmnEngineConfiguration);
        Map<String, List<VariableInstance>> instancesByName = CmmnAggregation.groupVariableInstancesByName(variableInstances);
        boolean aggregateMulti = this.shouldAggregateForMultipleInstances();
        for (Map.Entry<String, VariableAggregationDefinition> entry : aggregationsByTarget.entrySet()) {
            String varName = entry.getKey();
            if (aggregateMulti) {
                VariableAggregationDefinition aggregation = aggregationsByTarget.get(varName);
                PlanItemVariableAggregator aggregator = CmmnAggregation.resolveVariableAggregator(aggregation, planItemInstanceEntity);
                List<VariableInstance> counterVariables = instancesByName.getOrDefault("__flowableCounter__" + varName, Collections.emptyList());
                List<VariableInstance> varValues = instancesByName.getOrDefault(varName, Collections.emptyList());
                CmmnAggregation.sortVariablesByCounter(varValues, counterVariables);
                Object value = aggregator.aggregateMultiVariables((DelegatePlanItemInstance)planItemInstanceEntity, varValues, BaseVariableAggregatorContext.complete(aggregation));
                if (aggregation.isStoreAsTransientVariable()) {
                    planItemInstanceEntity.getParentVariableScope().setTransientVariable(varName, value);
                    continue;
                }
                planItemInstanceEntity.getParentVariableScope().setVariable(varName, value);
                continue;
            }
            planItemInstanceEntity.getParentVariableScope().removeVariable(varName);
        }
        variableInstances.forEach(arg_0 -> ((VariableService)variableService).deleteVariableInstance(arg_0));
    }

    protected abstract boolean shouldAggregateForSingleInstance();

    protected abstract boolean shouldAggregateForMultipleInstances();

    public abstract boolean isEvaluateRepetitionRule();
}

