/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.DecisionTableKeyAwareConverter;
import org.flowable.cmmn.editor.json.model.CmmnModelInfo;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public class ServiceTaskJsonConverter
extends BaseCmmnJsonConverter
implements DecisionTableKeyAwareConverter {
    protected static final Map<String, String> TYPE_TO_STENCILSET = new HashMap<String, String>();
    protected Map<String, CmmnModelInfo> decisionTableKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        ServiceTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        ServiceTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ServiceTask", ServiceTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(HttpServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(ScriptServiceTask.class, ServiceTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        ServiceTask serviceTask;
        String stencilId;
        PlanItem planItem;
        PlanItemDefinition planItemDefinition;
        if (baseElement instanceof PlanItem && (planItemDefinition = (planItem = (PlanItem)baseElement).getPlanItemDefinition()) instanceof ServiceTask && (stencilId = TYPE_TO_STENCILSET.get((serviceTask = (ServiceTask)planItemDefinition).getType())) != null) {
            return stencilId;
        }
        return "ServiceTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        ServiceTask serviceTask = (ServiceTask)((PlanItem)baseElement).getPlanItemDefinition();
        if ("http".equalsIgnoreCase(serviceTask.getType())) {
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            }
            this.setPropertyFieldValue("httptaskrequestmethod", "requestMethod", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequesturl", "requestUrl", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestheaders", "requestHeaders", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestbody", "requestBody", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestbodyencoding", "requestBodyEncoding", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequesttimeout", "requestTimeout", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskdisallowredirects", "disallowRedirects", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskfailstatuscodes", "failStatusCodes", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskhandlestatuscodes", "handleStatusCodes", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskresponsevariablename", "responseVariableName", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskignoreexception", "ignoreException", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaverequestvariables", "saveRequestVariables", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseparameters", "saveResponseParameters", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskresultvariableprefix", "resultVariablePrefix", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseparameterstransient", "saveResponseParametersTransient", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseasjson", "saveResponseVariableAsJson", serviceTask, propertiesNode);
        } else if ("script".equalsIgnoreCase(serviceTask.getType())) {
            propertiesNode.put("scriptformat", ((ScriptServiceTask)serviceTask).getScriptFormat());
            this.setPropertyFieldValue("scripttext", "scripttext", serviceTask, propertiesNode);
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
        } else {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskexpression", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskdelegateexpression", serviceTask.getImplementation());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
            this.addFieldExtensions(serviceTask.getFieldExtensions(), propertiesNode);
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode itemsArrayNode;
        JsonNode fieldsNode;
        ServiceTask task = new ServiceTask();
        task.setType("java");
        if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode));
        }
        if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode))) {
            task.setResultVariableName(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode));
        }
        if ((fieldsNode = CmmnJsonConverterUtil.getProperty("servicetaskfields", elementNode)) != null && (itemsArrayNode = fieldsNode.get("fields")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode nameNode = itemNode.get("name");
                if (nameNode == null || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                FieldExtension field = new FieldExtension();
                field.setFieldName(nameNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("stringValue", itemNode))) {
                    field.setStringValue(this.getValueAsString("stringValue", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("string", itemNode))) {
                    field.setStringValue(this.getValueAsString("string", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("expression", itemNode))) {
                    field.setExpression(this.getValueAsString("expression", itemNode));
                }
                task.getFieldExtensions().add(field);
            }
        }
        return task;
    }

    protected void setPropertyFieldValue(String propertyName, String fieldName, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!fieldName.equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(propertyName, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(propertyName, extension.getExpression(), propertiesNode);
        }
    }

    @Override
    public void setDecisionTableKeyMap(Map<String, CmmnModelInfo> decisionTableKeyMap) {
        this.decisionTableKeyMap = decisionTableKeyMap;
    }

    static {
        TYPE_TO_STENCILSET.put("http", "HttpTask");
        TYPE_TO_STENCILSET.put("script", "ScriptTask");
    }
}

