/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.LanguageAccessor;
import com.oracle.truffle.api.TruffleLanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TruffleContext
implements AutoCloseable {
    static final TruffleContext EMPTY = new TruffleContext();
    private static final ThreadLocal<List<Object>> CONTEXT_ASSERT_STACK;
    final Object impl;
    final boolean closeable;

    TruffleContext(Object impl) {
        this.impl = impl;
        this.closeable = false;
    }

    private TruffleContext(TruffleLanguage.Env env, Map<String, Object> config) {
        this.impl = LanguageAccessor.engineAccess().createInternalContext(env.getVMObject(), config, this);
        this.closeable = false;
        LanguageAccessor.engineAccess().initializeInternalContext(env.getVMObject(), this.impl);
    }

    private TruffleContext(Object impl, boolean closeable) {
        this.impl = impl;
        this.closeable = closeable;
    }

    private TruffleContext() {
        this.impl = null;
        this.closeable = false;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleContext getParent() {
        return LanguageAccessor.engineAccess().getParentContext(this.impl);
    }

    public Object enter() {
        Object prev = LanguageAccessor.engineAccess().enterInternalContext(this.impl);
        if (CONTEXT_ASSERT_STACK != null) {
            TruffleContext.verifyEnter(prev);
        }
        return prev;
    }

    public void leave(Object prev) {
        if (CONTEXT_ASSERT_STACK != null) {
            TruffleContext.verifyLeave(prev);
        }
        LanguageAccessor.engineAccess().leaveInternalContext(this.impl, prev);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void close() {
        if (!this.closeable) {
            throw new UnsupportedOperationException("It's not possible to close a foreign context.");
        }
        LanguageAccessor.engineAccess().closeInternalContext(this.impl);
    }

    @CompilerDirectives.TruffleBoundary
    private static void verifyEnter(Object prev) {
        assert (CONTEXT_ASSERT_STACK != null);
        CONTEXT_ASSERT_STACK.get().add(prev);
    }

    @CompilerDirectives.TruffleBoundary
    private static void verifyLeave(Object prev) {
        assert (CONTEXT_ASSERT_STACK != null);
        List<Object> list = CONTEXT_ASSERT_STACK.get();
        assert (!list.isEmpty()) : "Assert stack is empty.";
        Object expectedPrev = list.get(list.size() - 1);
        assert (prev == expectedPrev) : "Invalid prev argument provided in TruffleContext.leave(Object).";
        list.remove(list.size() - 1);
    }

    static {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        CONTEXT_ASSERT_STACK = assertions ? new ThreadLocal<List<Object>>(){

            @Override
            protected List<Object> initialValue() {
                return new ArrayList<Object>();
            }
        } : null;
    }

    public final class Builder {
        private final TruffleLanguage.Env sourceEnvironment;
        private Map<String, Object> config;

        Builder(TruffleLanguage.Env env) {
            this.sourceEnvironment = env;
        }

        @CompilerDirectives.TruffleBoundary
        public Builder config(String key, Object value) {
            if (this.config == null) {
                this.config = new HashMap<String, Object>();
            }
            this.config.put(key, value);
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleContext build() {
            TruffleContext context = new TruffleContext(this.sourceEnvironment, this.config);
            return new TruffleContext(context.impl, true);
        }
    }
}

