/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributorContext;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoPropertyMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingVectorFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.AbstractPropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.PojoCompositeFieldModelContributor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PropertyMappingVectorFieldOptionsStepImpl
extends AbstractPropertyMappingFieldOptionsStep<PropertyMappingVectorFieldOptionsStep>
implements PropertyMappingVectorFieldOptionsStep,
PojoPropertyMetadataContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    PropertyMappingVectorFieldOptionsStepImpl(PropertyMappingStep parent, final Integer dimension, String relativeFieldName) {
        super(parent, relativeFieldName, new PojoCompositeFieldModelContributor.DefaultInitiator(){

            @Override
            public <F> IndexFieldTypeOptionsStep<?, F> initiate(IndexFieldTypeFactory factory, Class<F> clazz) {
                if (dimension == null) {
                    throw log.vectorDimensionNotSpecified();
                }
                if (clazz.isArray()) {
                    return factory.asVector(dimension.intValue(), clazz);
                }
                return factory.as(clazz);
            }
        }, FieldModelContributorContext::vectorTypeOptionsStep);
        this.extractors(ContainerExtractorPath.noExtractors());
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep projectable(Projectable projectable) {
        this.fieldModelContributor.add(c -> c.vectorTypeOptionsStep().projectable(projectable));
        return this.thisAsS();
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep searchable(Searchable searchable) {
        this.fieldModelContributor.add(c -> c.vectorTypeOptionsStep().searchable(searchable));
        return this;
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep vectorSimilarity(VectorSimilarity vectorSimilarity) {
        this.fieldModelContributor.add(c -> c.vectorTypeOptionsStep().vectorSimilarity(vectorSimilarity));
        return this.thisAsS();
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep beamWidth(int beamWidth) {
        this.fieldModelContributor.add(c -> c.vectorTypeOptionsStep().beamWidth(beamWidth));
        return this.thisAsS();
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep maxConnections(int maxConnections) {
        this.fieldModelContributor.add(c -> c.vectorTypeOptionsStep().maxConnections(maxConnections));
        return this.thisAsS();
    }

    @Override
    public PropertyMappingVectorFieldOptionsStep indexNullAs(String indexNullAs) {
        this.fieldModelContributor.add(c -> c.indexNullAs(indexNullAs));
        return this.thisAsS();
    }

    @Override
    PropertyMappingVectorFieldOptionsStepImpl thisAsS() {
        return this;
    }
}

