/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Booleans;
import org.immutables.value.internal.$processor$.meta.$AnnotationInjections;

public class $InjectAnnotationMirror
implements $AnnotationInjections.InjectAnnotation {
    public static final String QUALIFIED_NAME = "org.immutables.annotate.InjectAnnotation";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.AnnotationInjections.$InjectAnnotation";
    private final AnnotationMirror annotationMirror;
    private final String code;
    private final TypeMirror type;
    private final String typeName;
    private final boolean ifPresent;
    private final $AnnotationInjections.InjectAnnotation.Where[] target;
    private final String deduplicationKey;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "InjectAnnotation";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$InjectAnnotationMirror> find(Element element) {
        return $InjectAnnotationMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$InjectAnnotationMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $InjectAnnotationMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$InjectAnnotationMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $InjectAnnotationMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $InjectAnnotationMirror from(TypeElement element) {
        return new $InjectAnnotationMirror(element);
    }

    public static $Optional<$InjectAnnotationMirror> from(AnnotationMirror mirror) {
        return $InjectAnnotationMirror.find(Collections.singleton(mirror));
    }

    private $InjectAnnotationMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        String code = null;
        TypeMirror type = null;
        String typeName = null;
        boolean ifPresent = false;
        $AnnotationInjections.InjectAnnotation.Where[] target = null;
        String deduplicationKey = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("code".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectAnnotation");
                }
                CodeExtractor codeExtractor$ = new CodeExtractor();
                annotationValue$.accept(codeExtractor$, null);
                code = codeExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectAnnotation");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                typeName = typeExtractor$.name();
                continue;
            }
            if ("ifPresent".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectAnnotation");
                }
                IfPresentExtractor ifPresentExtractor$ = new IfPresentExtractor();
                annotationValue$.accept(ifPresentExtractor$, null);
                ifPresent = ifPresentExtractor$.get();
                continue;
            }
            if ("target".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectAnnotation");
                }
                TargetExtractor targetExtractor$ = new TargetExtractor();
                annotationValue$.accept(targetExtractor$, null);
                target = targetExtractor$.get();
                continue;
            }
            if (!"deduplicationKey".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectAnnotation");
            }
            DeduplicationKeyExtractor deduplicationKeyExtractor$ = new DeduplicationKeyExtractor();
            annotationValue$.accept(deduplicationKeyExtractor$, null);
            deduplicationKey = deduplicationKeyExtractor$.get();
        }
        this.code = $Preconditions.checkNotNull(code, "default attribute 'code'");
        this.type = $Preconditions.checkNotNull(type, "default attribute 'type'");
        this.typeName = $Preconditions.checkNotNull(typeName, "default attribute 'type'");
        this.ifPresent = ifPresent;
        this.target = $Preconditions.checkNotNull(target, "default attribute 'target'");
        this.deduplicationKey = $Preconditions.checkNotNull(deduplicationKey, "default attribute 'deduplicationKey'");
    }

    private $InjectAnnotationMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String code = null;
        TypeMirror type = null;
        String typeName = null;
        boolean ifPresent = false;
        $AnnotationInjections.InjectAnnotation.Where[] target = null;
        String deduplicationKey = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("code".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'code' attribute of @InjectAnnotation");
                }
                CodeExtractor codeExtractor$ = new CodeExtractor();
                annotationValue$.accept(codeExtractor$, null);
                code = codeExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'type' attribute of @InjectAnnotation");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                typeName = typeExtractor$.name();
                continue;
            }
            if ("ifPresent".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'ifPresent' attribute of @InjectAnnotation");
                }
                IfPresentExtractor ifPresentExtractor$ = new IfPresentExtractor();
                annotationValue$.accept(ifPresentExtractor$, null);
                ifPresent = ifPresentExtractor$.get();
                continue;
            }
            if ("target".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'target' attribute of @InjectAnnotation");
                }
                TargetExtractor targetExtractor$ = new TargetExtractor();
                annotationValue$.accept(targetExtractor$, null);
                target = targetExtractor$.get();
                continue;
            }
            if (!"deduplicationKey".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'deduplicationKey' attribute of @InjectAnnotation");
            }
            DeduplicationKeyExtractor deduplicationKeyExtractor$ = new DeduplicationKeyExtractor();
            annotationValue$.accept(deduplicationKeyExtractor$, null);
            deduplicationKey = deduplicationKeyExtractor$.get();
        }
        this.code = $Preconditions.checkNotNull(code, "value for 'code'");
        this.type = $Preconditions.checkNotNull(type, "value for 'type'");
        this.typeName = $Preconditions.checkNotNull(typeName, "Value for 'type'");
        this.ifPresent = ifPresent;
        this.target = $Preconditions.checkNotNull(target, "value for 'target'");
        this.deduplicationKey = $Preconditions.checkNotNull(deduplicationKey, "value for 'deduplicationKey'");
    }

    @Override
    public String code() {
        return this.code;
    }

    public String typeName() {
        return this.typeName;
    }

    public TypeMirror typeMirror() {
        return this.type;
    }

    @Override
    @Deprecated
    public Class<? extends Annotation> type() {
        throw new UnsupportedOperationException("Use 'typeMirror()' or 'typeName()'");
    }

    @Override
    public boolean ifPresent() {
        return this.ifPresent;
    }

    @Override
    public $AnnotationInjections.InjectAnnotation.Where[] target() {
        return ($AnnotationInjections.InjectAnnotation.Where[])this.target.clone();
    }

    @Override
    public String deduplicationKey() {
        return this.deduplicationKey;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $AnnotationInjections.InjectAnnotation.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "code".hashCode() ^ this.code.hashCode();
        h += 127 * "type".hashCode() ^ this.typeName.hashCode();
        h += 127 * "ifPresent".hashCode() ^ $Booleans.hashCode(this.ifPresent);
        h += 127 * "target".hashCode() ^ Arrays.hashCode((Object[])this.target);
        return h += 127 * "deduplicationKey".hashCode() ^ this.deduplicationKey.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $InjectAnnotationMirror) {
            $InjectAnnotationMirror otherMirror = ($InjectAnnotationMirror)other;
            return this.code.equals(otherMirror.code) && this.typeName.equals(otherMirror.typeName) && this.ifPresent == otherMirror.ifPresent && Arrays.equals((Object[])this.target, (Object[])otherMirror.target) && this.deduplicationKey.equals(otherMirror.deduplicationKey);
        }
        return false;
    }

    @Override
    public String toString() {
        return "InjectAnnotationMirror:" + this.annotationMirror;
    }

    private static class CodeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CodeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'code' in @org.immutables.annotate.InjectAnnotation");
        }
    }

    private static class TypeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror value;

        private TypeExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        TypeMirror get() {
            return this.value;
        }

        public String name() {
            return this.value.toString();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'type' in @org.immutables.annotate.InjectAnnotation");
        }
    }

    private static class IfPresentExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private IfPresentExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'ifPresent' in @org.immutables.annotate.InjectAnnotation");
        }
    }

    private static class TargetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        $AnnotationInjections.InjectAnnotation.Where[] values;
        int position;

        private TargetExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.values[this.position++] = $AnnotationInjections.InjectAnnotation.Where.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new $AnnotationInjections.InjectAnnotation.Where[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        $AnnotationInjections.InjectAnnotation.Where[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'target' in @org.immutables.annotate.InjectAnnotation");
        }
    }

    private static class DeduplicationKeyExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private DeduplicationKeyExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'deduplicationKey' in @org.immutables.annotate.InjectAnnotation");
        }
    }
}

