/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    STRING_KEYED_JDBC_STORE,
    BINARY_KEYED_JDBC_STORE,
    MIXED_KEYED_JDBC_STORE,
    TABLE_JDBC_STORE,
    QUERY_JDBC_STORE,
    CONNECTION_POOL,
    CDI_DATA_SOURCE,
    DATA_SOURCE,
    SIMPLE_CONNECTION,
    STRING_KEYED_TABLE,
    DATA_COLUMN,
    ID_COLUMN,
    TIMESTAMP_COLUMN,
    SEGMENT_COLUMN,
    SCHEMA,
    QUERIES,
    SELECT_SINGLE,
    SELECT_ALL,
    DELETE_SINGLE,
    DELETE_ALL,
    UPSERT,
    SIZE;

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    private Element() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

