/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import org.kurento.jsonrpc.client.AbstractJsonRpcClientWebSocket;
import org.kurento.jsonrpc.client.AbstractJsonRpcWebSocketClientHandler;
import org.kurento.jsonrpc.client.JsonRpcWSConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientNettyWebSocket
extends AbstractJsonRpcClientWebSocket {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcClientNettyWebSocket.class);
    private volatile Channel channel;
    private volatile EventLoopGroup group;
    private volatile JsonRpcWebSocketClientHandler handler;

    public JsonRpcClientNettyWebSocket(String url) {
        this(url, null);
    }

    public JsonRpcClientNettyWebSocket(String url, JsonRpcWSConnectionListener connectionListener) {
        super(url, connectionListener);
        log.debug("{} Creating JsonRPC NETTY Websocket client", (Object)this.label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendTextMessage(String jsonMessage) throws IOException {
        if (this.channel == null || !this.channel.isWritable() || !this.channel.isActive()) {
            throw new IllegalStateException(this.label + " JsonRpcClient is disconnected from WebSocket server at '" + this.uri + "'");
        }
        Channel channel = this.channel;
        synchronized (channel) {
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(jsonMessage));
        }
    }

    @Override
    protected boolean isNativeClientConnected() {
        return this.channel != null && this.channel.isActive();
    }

    @Override
    protected void connectNativeClient() throws TimeoutException, Exception {
        if (this.channel == null || !this.channel.isActive() || this.group == null || this.group.isShuttingDown() || this.group.isShutdown()) {
            String host;
            SslContext sslCtx;
            log.info("{} Connecting native client", (Object)this.label);
            boolean ssl = "wss".equalsIgnoreCase(this.uri.getScheme());
            try {
                sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            }
            catch (SSLException e) {
                log.error("{} Could not create SSL Context", (Object)this.label, (Object)e);
                throw new IllegalArgumentException("Could not create SSL context. See logs for more details", e);
            }
            String scheme = this.uri.getScheme() == null ? "ws" : this.uri.getScheme();
            String string = host = this.uri.getHost() == null ? "127.0.0.1" : this.uri.getHost();
            final int port = this.uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : this.uri.getPort();
            if (this.group == null || this.group.isShuttingDown() || this.group.isShutdown() || this.group.isTerminated()) {
                log.info("{} Creating new NioEventLoopGroup", (Object)this.label);
                this.group = new NioEventLoopGroup();
            }
            if (this.channel != null) {
                log.info("{} Closing previously existing channel when connecting native client", (Object)this.label);
                this.closeChannel();
            }
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    log.info("{} Initiating new Netty channel. Will create new handler too!", (Object)JsonRpcClientNettyWebSocket.this.label);
                    JsonRpcClientNettyWebSocket.this.handler = new JsonRpcWebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)JsonRpcClientNettyWebSocket.this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)AbstractJsonRpcClientWebSocket.maxPacketSize));
                    ChannelPipeline p = ch.pipeline();
                    p.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, JsonRpcClientNettyWebSocket.this.idleTimeout / 1000));
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, JsonRpcClientNettyWebSocket.this.handler});
                }
            })).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout);
            int numRetries = 0;
            int maxRetries = 5;
            while (this.channel == null || !this.channel.isOpen()) {
                try {
                    this.channel = b.connect(host, port).sync().channel();
                    this.handler.handshakeFuture().sync();
                }
                catch (InterruptedException e) {
                    log.warn("{} ERROR connecting WS Netty client, opening channel", (Object)this.label, (Object)e);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof WebSocketHandshakeException && numRetries < 5) {
                        log.warn("{} Upgrade exception when trying to connect to {}. Try {} of {}. Retrying in 200ms ", new Object[]{this.label, this.uri, numRetries + 1, 5});
                        Thread.sleep(200L);
                        ++numRetries;
                        continue;
                    }
                    throw e;
                }
            }
            this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    log.info("{} channel closed", (Object)JsonRpcClientNettyWebSocket.this.label);
                    JsonRpcClientNettyWebSocket.this.handleReconnectDisconnection(1001, "Channel closed");
                }
            });
        }
    }

    @Override
    public void closeNativeClient() {
        this.closeChannel();
        if (this.group != null) {
            this.group.shutdownGracefully();
        } else {
            log.warn("{} Trying to close a JsonRpcClientNettyWebSocket with group == null", (Object)this.label);
        }
        this.group = null;
        this.handler = null;
    }

    private void closeChannel() {
        if (this.channel != null) {
            log.debug("{} Closing client", (Object)this.label);
            try {
                this.channel.close().sync();
            }
            catch (Exception e) {
                log.debug("{} Could not properly close websocket client. Reason: {}", new Object[]{this.label, e.getMessage(), e});
            }
            this.channel = null;
        } else {
            log.warn("{} Trying to close a JsonRpcClientNettyWebSocket with channel == null", (Object)this.label);
        }
    }

    public class JsonRpcWebSocketClientHandler
    extends AbstractJsonRpcWebSocketClientHandler {
        private StringBuilder partialText;

        public JsonRpcWebSocketClientHandler(WebSocketClientHandshaker handshaker) {
            super(handshaker);
            this.partialText = new StringBuilder();
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.handshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            log.debug("{} channel active", (Object)JsonRpcClientNettyWebSocket.this.label);
            this.handshaker.handshake(ctx.channel());
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            log.debug("{} channel inactive", (Object)JsonRpcClientNettyWebSocket.this.label);
            JsonRpcClientNettyWebSocket.this.handleReconnectDisconnection(0, "Unknown reason");
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                log.debug("{} Idle state event received", (Object)JsonRpcClientNettyWebSocket.this.label);
                JsonRpcClientNettyWebSocket.this.handleReconnectDisconnection(0, "Idle event received");
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                log.debug("{} WebSocket Client connected!", (Object)JsonRpcClientNettyWebSocket.this.label);
                this.handshakeFuture.setSuccess();
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                if (textFrame.isFinalFragment()) {
                    JsonRpcClientNettyWebSocket.this.receivedTextMessage(textFrame.text());
                } else {
                    this.partialText.append(textFrame.text());
                }
            } else if (frame instanceof ContinuationWebSocketFrame) {
                ContinuationWebSocketFrame continuationFrame = (ContinuationWebSocketFrame)frame;
                this.partialText.append(continuationFrame.text());
                if (continuationFrame.isFinalFragment()) {
                    JsonRpcClientNettyWebSocket.this.receivedTextMessage(this.partialText.toString());
                    this.partialText.setLength(0);
                }
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
                log.info("{} Received close frame from server. Will close client! Reason: {}", (Object)JsonRpcClientNettyWebSocket.this.label, (Object)closeFrame.reasonText());
            } else {
                log.warn("{} Received frame of type {}. Will be ignored", (Object)JsonRpcClientNettyWebSocket.this.label, (Object)frame.getClass().getSimpleName());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.warn("{} Exception caught in Netty websocket handler", (Object)JsonRpcClientNettyWebSocket.this.label, (Object)cause);
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure(cause);
            }
            try {
                JsonRpcClientNettyWebSocket.this.close();
            }
            catch (IOException e) {
                log.warn("{} Exception closing Netty websocket client", (Object)JsonRpcClientNettyWebSocket.this.label);
            }
        }
    }
}

