/*
 * Decompiled with CFR 0.152.
 */
package org.LatencyUtils;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.IntervalEstimator;
import org.LatencyUtils.PauseDetector;
import org.LatencyUtils.PauseDetectorListener;
import org.LatencyUtils.SimplePauseDetector;
import org.LatencyUtils.TimeCappedMovingAverageIntervalEstimator;
import org.LatencyUtils.TimeServices;

public class LatencyStats {
    private static Builder defaultBuilder = new Builder();
    private static final TimeServices.ScheduledExecutor latencyStatsScheduledExecutor = new TimeServices.ScheduledExecutor();
    private static PauseDetector defaultPauseDetector;
    private final long lowestTrackableLatency;
    private final long highestTrackableLatency;
    private final int numberOfSignificantValueDigits;
    private AtomicHistogram currentRecordingHistogram;
    private Histogram currentPauseCorrectionsHistogram;
    private AtomicHistogram intervalRawDataHistogram;
    private Histogram intervalPauseCorrectionsHistogram;
    private Histogram uncorrectedAccumulatedHistogram;
    private Histogram accumulatedHistogram;
    private volatile long recordingStartEpoch = 0L;
    private volatile long recordingEndEpoch = 0L;
    private static final AtomicLongFieldUpdater<LatencyStats> recordingStartEpochUpdater;
    private static final AtomicLongFieldUpdater<LatencyStats> recordingEndEpochUpdater;
    private final PauseTracker pauseTracker;
    private final IntervalEstimator intervalEstimator;
    private final PauseDetector pauseDetector;

    public static void setDefaultPauseDetector(PauseDetector pauseDetector) {
        defaultPauseDetector = pauseDetector;
    }

    public static PauseDetector getDefaultPauseDetector() {
        return defaultPauseDetector;
    }

    public LatencyStats() {
        this(defaultBuilder.lowestTrackableLatency, defaultBuilder.highestTrackableLatency, defaultBuilder.numberOfSignificantValueDigits, defaultBuilder.intervalEstimatorWindowLength, defaultBuilder.intervalEstimatorTimeCap, defaultBuilder.pauseDetector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LatencyStats(long lowestTrackableLatency, long highestTrackableLatency, int numberOfSignificantValueDigits, int intervalEstimatorWindowLength, long intervalEstimatorTimeCap, PauseDetector pauseDetector) {
        if (pauseDetector == null) {
            if (defaultPauseDetector == null) {
                Class<LatencyStats> clazz = LatencyStats.class;
                // MONITORENTER : org.LatencyUtils.LatencyStats.class
                if (defaultPauseDetector == null) {
                    defaultPauseDetector = new SimplePauseDetector();
                }
                // MONITOREXIT : clazz
            }
            this.pauseDetector = defaultPauseDetector;
        } else {
            this.pauseDetector = pauseDetector;
        }
        this.lowestTrackableLatency = lowestTrackableLatency;
        this.highestTrackableLatency = highestTrackableLatency;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.currentRecordingHistogram = new AtomicHistogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalRawDataHistogram = new AtomicHistogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.currentPauseCorrectionsHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalPauseCorrectionsHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.accumulatedHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.uncorrectedAccumulatedHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(intervalEstimatorWindowLength, intervalEstimatorTimeCap, this.pauseDetector);
        this.pauseTracker = new PauseTracker(this.pauseDetector, this);
    }

    public void recordLatency(long latency) {
        recordingStartEpochUpdater.incrementAndGet(this);
        this.trackRecordingInterval();
        this.currentRecordingHistogram.recordValue(latency);
        recordingEndEpochUpdater.incrementAndGet(this);
    }

    public synchronized Histogram getAccumulatedHistogram() {
        return this.accumulatedHistogram.copy();
    }

    public synchronized void getAccumulatedHistogramInto(Histogram targetHistogram) {
        this.accumulatedHistogram.copyInto((AbstractHistogram)targetHistogram);
    }

    public synchronized void addAccumulatedHistogramTo(Histogram toHistogram) {
        toHistogram.add((AbstractHistogram)this.accumulatedHistogram);
    }

    public synchronized Histogram getUncorrectedAccumulatedHistogram() {
        return this.uncorrectedAccumulatedHistogram.copy();
    }

    public synchronized Histogram getIntervalHistogram() {
        Histogram intervalHistogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
        this.getIntervalHistogramInto(intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void getIntervalHistogramInto(Histogram targetHistogram) {
        this.intervalRawDataHistogram.copyInto((AbstractHistogram)targetHistogram);
        targetHistogram.add((AbstractHistogram)this.intervalPauseCorrectionsHistogram);
    }

    public synchronized void addIntervalHistogramTo(Histogram toHistogram) {
        toHistogram.add((AbstractHistogram)this.intervalRawDataHistogram);
        toHistogram.add((AbstractHistogram)this.intervalPauseCorrectionsHistogram);
    }

    public synchronized Histogram getUncorrectedIntervalHistogram() {
        Histogram intervalHistogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
        this.intervalRawDataHistogram.copyInto((AbstractHistogram)intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void forceIntervalSample() {
        this.updateHistograms();
    }

    public synchronized void resetAccumulatedHistogram() {
        long now = System.currentTimeMillis();
        this.accumulatedHistogram.reset();
        this.accumulatedHistogram.setStartTimeStamp(now);
        this.uncorrectedAccumulatedHistogram.reset();
        this.uncorrectedAccumulatedHistogram.setStartTimeStamp(now);
    }

    public synchronized void stop() {
        this.pauseTracker.stop();
        latencyStatsScheduledExecutor.shutdown();
    }

    public IntervalEstimator getIntervalEstimator() {
        return this.intervalEstimator;
    }

    public PauseDetector getPauseDetector() {
        return this.pauseDetector;
    }

    synchronized void recordDetectedPause(long pauseLength, long pauseEndTime) {
        long estimatedInterval = this.intervalEstimator.getEstimatedInterval(pauseEndTime);
        long observedLatencyMinbar = pauseLength - estimatedInterval;
        if (observedLatencyMinbar >= estimatedInterval) {
            this.currentPauseCorrectionsHistogram.recordValueWithExpectedInterval(observedLatencyMinbar, estimatedInterval);
        }
    }

    void trackRecordingInterval() {
        long now = TimeServices.nanoTime();
        this.intervalEstimator.recordInterval(now);
    }

    void swapRecordingHistograms() {
        AtomicHistogram tempHistogram = this.intervalRawDataHistogram;
        this.intervalRawDataHistogram = this.currentRecordingHistogram;
        this.currentRecordingHistogram = tempHistogram;
    }

    void swapPauseCorrectionHistograms() {
        Histogram tempHistogram = this.intervalPauseCorrectionsHistogram;
        this.intervalPauseCorrectionsHistogram = this.currentPauseCorrectionsHistogram;
        this.currentPauseCorrectionsHistogram = tempHistogram;
    }

    synchronized void swapHistograms() {
        this.swapRecordingHistograms();
        this.swapPauseCorrectionHistograms();
    }

    synchronized void updateHistograms() {
        this.intervalRawDataHistogram.reset();
        this.intervalPauseCorrectionsHistogram.reset();
        this.swapHistograms();
        long now = System.currentTimeMillis();
        this.currentRecordingHistogram.setStartTimeStamp(now);
        this.currentPauseCorrectionsHistogram.setStartTimeStamp(now);
        this.intervalRawDataHistogram.setEndTimeStamp(now);
        this.intervalPauseCorrectionsHistogram.setEndTimeStamp(now);
        long startEpoch = recordingStartEpochUpdater.get(this);
        while (recordingEndEpochUpdater.get(this) < startEpoch) {
        }
        this.uncorrectedAccumulatedHistogram.add((AbstractHistogram)this.intervalRawDataHistogram);
        this.uncorrectedAccumulatedHistogram.setEndTimeStamp(now);
        this.accumulatedHistogram.add((AbstractHistogram)this.intervalRawDataHistogram);
        this.accumulatedHistogram.add((AbstractHistogram)this.intervalPauseCorrectionsHistogram);
        this.accumulatedHistogram.setEndTimeStamp(now);
    }

    static {
        recordingStartEpochUpdater = AtomicLongFieldUpdater.newUpdater(LatencyStats.class, "recordingStartEpoch");
        recordingEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(LatencyStats.class, "recordingEndEpoch");
    }

    static class PauseTracker
    extends WeakReference<LatencyStats>
    implements PauseDetectorListener {
        final PauseDetector pauseDetector;

        PauseTracker(PauseDetector pauseDetector, LatencyStats latencyStats) {
            super(latencyStats);
            this.pauseDetector = pauseDetector;
            pauseDetector.addListener(this);
        }

        public void stop() {
            this.pauseDetector.removeListener(this);
        }

        @Override
        public void handlePauseEvent(long pauseLength, long pauseEndTime) {
            LatencyStats latencyStats = (LatencyStats)this.get();
            if (latencyStats != null) {
                latencyStats.recordDetectedPause(pauseLength, pauseEndTime);
            } else {
                this.stop();
            }
        }
    }

    public static class Builder {
        private long lowestTrackableLatency = 1000L;
        private long highestTrackableLatency = 3600000000000L;
        private int numberOfSignificantValueDigits = 2;
        private int intervalEstimatorWindowLength = 1024;
        private long intervalEstimatorTimeCap = 10000000000L;
        private PauseDetector pauseDetector = null;

        public static Builder create() {
            return new Builder();
        }

        public Builder lowestTrackableLatency(long lowestTrackableLatency) {
            this.lowestTrackableLatency = lowestTrackableLatency;
            return this;
        }

        public Builder highestTrackableLatency(long highestTrackableLatency) {
            this.highestTrackableLatency = highestTrackableLatency;
            return this;
        }

        public Builder numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
            return this;
        }

        public Builder intervalEstimatorWindowLength(int intervalEstimatorWindowLength) {
            this.intervalEstimatorWindowLength = intervalEstimatorWindowLength;
            return this;
        }

        public Builder intervalEstimatorTimeCap(long intervalEstimatorTimeCap) {
            this.intervalEstimatorTimeCap = intervalEstimatorTimeCap;
            return this;
        }

        public Builder pauseDetector(PauseDetector pauseDetector) {
            this.pauseDetector = pauseDetector;
            return this;
        }

        public LatencyStats build() {
            return new LatencyStats(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits, this.intervalEstimatorWindowLength, this.intervalEstimatorTimeCap, this.pauseDetector);
        }
    }
}

