/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateFactory;

public class TcpFrameDemuxingDecodingStateFactory
implements DecodingStateFactory {
    private final DecodingStateFactory m_decodingStateFactory;

    public TcpFrameDemuxingDecodingStateFactory(DecodingStateFactory decodingStateFactory) {
        this.m_decodingStateFactory = decodingStateFactory;
    }

    public DecodingState newState() {
        return new DemuxingDecodingState(this.m_decodingStateFactory);
    }

    private static final class DemuxingDecodingState
    implements DecodingState {
        private final DecodingStateFactory m_stateFactory;

        private DemuxingDecodingState(DecodingStateFactory stateFactory) {
            this.m_stateFactory = stateFactory;
        }

        public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            in.mark();
            short firstByte = in.getUnsigned();
            in.reset();
            int masked = firstByte & 0xC0;
            if (masked > 0) {
                return this.m_stateFactory.newState();
            }
            return null;
        }
    }
}

