/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import java.io.OutputStream;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.lastbamboo.common.tcp.frame.TcpFrameIoSessionOutputStream;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.mina.IoSessionOutputStreamFactory;
import org.littleshoot.util.mina.SocketIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpFrameIoHandler
extends SocketIoHandler {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private int m_handlerId = s_handlerId++;
    private static int s_handlerId = 0;

    public TcpFrameIoHandler() {
        super(new IoSessionOutputStreamFactory(){

            public OutputStream newStream(IoSession session) {
                return new TcpFrameIoSessionOutputStream(session);
            }
        });
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received message on TCP frame: {}", message);
        this.m_log.debug("TCP frames received: {}", (Object)session.getReadMessages());
        this.m_log.debug("TCP frame bytes received: {}", (Object)session.getReadBytes());
        TcpFrame frame = (TcpFrame)message;
        byte[] data = frame.getData();
        if (this.m_log.isDebugEnabled()) {
            // empty if block
        }
        super.messageReceived(session, (Object)ByteBuffer.wrap((byte[])data));
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.m_log.debug("TCP frame messages sent: {}", (Object)session.getWrittenMessages());
        this.m_log.debug("TCP frame bytes sent: {}", (Object)session.getWrittenBytes());
        super.messageSent(session, message);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.m_handlerId;
    }
}

