/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.lastbamboo.common.tcp.frame.TcpFrameLocalIoHandler;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.RuntimeIOException;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.transport.socket.nio.SocketConnector;
import org.littleshoot.mina.util.SessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpFrameServerIoHandler
implements IoHandler {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Map<IoSession, IoSession> m_remoteToLocalSessions = new ConcurrentHashMap<IoSession, IoSession>();
    private final InetSocketAddress m_serverAddress;

    public TcpFrameServerIoHandler(InetSocketAddress serverAddress) {
        this.m_serverAddress = serverAddress;
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received message on TCP frame: {}", message);
        TcpFrame frame = (TcpFrame)message;
        byte[] data = frame.getData();
        IoSession localSession = this.m_remoteToLocalSessions.get(session);
        this.m_log.debug("Writing raw data to local session");
        localSession.write((Object)ByteBuffer.wrap((byte[])data));
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.warn("Caught exception!!", cause);
    }

    public void messageSent(IoSession session, Object message) {
        this.m_log.debug("Sent message: {}", message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.m_remoteToLocalSessions.remove(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.m_log.debug("Session created!!");
        SessionUtil.initialize((IoSession)session);
        session.setIdleTime(IdleStatus.BOTH_IDLE, 60);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.m_log.debug("Closing idle session");
        session.close();
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        IoSession session;
        this.m_log.debug("Opened session with remote host...");
        if (this.m_remoteToLocalSessions.containsKey(ioSession)) {
            this.m_log.warn("We already have a session for: {}", (Object)ioSession);
            return;
        }
        this.m_log.debug("Opening new local socket for remote address: {}", (Object)ioSession);
        SocketConnector connector = new SocketConnector();
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)"TCP-Frame-Local-Server-Socket");
        connector.getDefaultConfig().setThreadModel((ThreadModel)threadModel);
        TcpFrameLocalIoHandler ioHandler = new TcpFrameLocalIoHandler(ioSession);
        ConnectFuture ioFuture = connector.connect((SocketAddress)this.m_serverAddress, (IoHandler)ioHandler);
        ioFuture.join(6000L);
        try {
            session = ioFuture.getSession();
            if (session == null) {
                throw new RuntimeIOException("Could not get session");
            }
        }
        catch (RuntimeIOException e) {
            this.m_log.debug("Could not connect to host: {}", (Object)this.m_serverAddress);
            this.m_log.debug("Reason for no connection: ", (Throwable)e);
            throw e;
        }
        if (!session.isConnected()) {
            this.m_log.error("Could not connect to server: {}", (Object)this.m_serverAddress);
        } else {
            this.m_log.debug("Connected to server: {}", (Object)this.m_serverAddress);
            this.m_remoteToLocalSessions.put(ioSession, session);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

