/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.codegen.profiling;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.compiler.v3_1.codegen.QueryExecutionEvent;
import org.neo4j.cypher.internal.compiler.v3_1.codegen.QueryExecutionTracer;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Id;

public class ProfilingTracer
implements QueryExecutionTracer {
    private static final Data ZERO = new Data();
    private final Clock clock;
    private final Map<Id, Data> data = new HashMap<Id, Data>();

    public ProfilingTracer() {
        this(Clock.SYSTEM_TIMER);
    }

    ProfilingTracer(Clock clock) {
        this.clock = clock;
    }

    public ProfilingInformation get(Id query) {
        Data value = this.data.get(query);
        return value == null ? ZERO : value;
    }

    public long timeOf(Id query) {
        return this.get(query).time();
    }

    public long dbHitsOf(Id query) {
        return this.get(query).dbHits();
    }

    public long rowsOf(Id query) {
        return this.get(query).rows();
    }

    @Override
    public QueryExecutionEvent executeOperator(Id queryId) {
        Data data = this.data.get(queryId);
        if (data == null && queryId != null) {
            data = new Data();
            this.data.put(queryId, data);
        }
        return new ExecutionEvent(this.clock, data);
    }

    private static class Data
    implements ProfilingInformation {
        private long time;
        private long hits;
        private long rows;

        private Data() {
        }

        public void update(long time, long hits, long rows) {
            this.time += time;
            this.hits += hits;
            this.rows += rows;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long dbHits() {
            return this.hits;
        }

        @Override
        public long rows() {
            return this.rows;
        }
    }

    private static class ExecutionEvent
    implements QueryExecutionEvent {
        private final long start;
        private final Clock clock;
        private final Data data;
        private long hitCount;
        private long rowCount;

        public ExecutionEvent(Clock clock, Data data) {
            this.clock = clock;
            this.data = data;
            this.start = clock.nanoTime();
        }

        @Override
        public void close() {
            long executionTime = this.clock.nanoTime() - this.start;
            if (this.data != null) {
                this.data.update(executionTime, this.hitCount, this.rowCount);
            }
        }

        @Override
        public void dbHit() {
            ++this.hitCount;
        }

        @Override
        public void row() {
            ++this.rowCount;
        }
    }

    public static interface Clock {
        public static final Clock SYSTEM_TIMER = System::nanoTime;

        public long nanoTime();
    }

    public static interface ProfilingInformation {
        public long time();

        public long dbHits();

        public long rows();
    }
}

