/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.util;

import java.io.DataInputStream;
import java.io.PrintStream;
import java.net.Socket;
import net.sf.jftp.util.JReciever;

public class JRawConnection
implements Runnable {
    private int timeout = 30000;
    private String host;
    private int port;
    private PrintStream out;
    private DataInputStream in;
    private Socket s;
    private JReciever jrcv;
    private boolean isOk = false;
    private boolean established = false;
    private boolean reciever = false;
    private Thread runner;

    public JRawConnection(String host, int port) {
        this(host, port, false);
    }

    public JRawConnection(String host, int port, boolean reciever) {
        this.host = host;
        this.port = port;
        this.reciever = reciever;
        this.runner = new Thread(this);
        this.runner.start();
    }

    @Override
    public void run() {
        try {
            this.s = new Socket(this.host, this.port);
            this.out = new PrintStream(this.s.getOutputStream());
            this.in = new DataInputStream(this.s.getInputStream());
            if (this.reciever) {
                JReciever jrcv = new JReciever(this.in);
            }
            this.isOk = true;
        }
        catch (Exception ex) {
            this.isOk = false;
        }
        this.established = true;
    }

    public boolean isThere() {
        for (int cnt = 0; !this.established && cnt < this.timeout; cnt += 100) {
            this.pause(100);
        }
        return this.isOk;
    }

    public void send(String data) {
        try {
            this.out.println(data);
        }
        catch (Exception ex) {
            System.out.println(ex + "@JConnection.send()");
        }
    }

    public PrintStream getInetOutputStream() {
        return this.out;
    }

    public DataInputStream getInetInputStream() {
        return this.in;
    }

    private void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

