/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.runners.model.Statement;
import org.powermock.core.MockRepository;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.core.agent.JavaAgentFrameworkRegister;
import org.powermock.core.agent.JavaAgentFrameworkRegisterFactory;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.ClassLoaderRegisterProxyFramework;

class PowerMockStatement
extends Statement {
    private static final String ANNOTATION_ENABLER = "org.powermock.api.extension.listener.AnnotationEnabler";
    private final Statement fNext;
    private final Object target;
    private final JavaAgentClassRegister agentClassRegister;
    private final JavaAgentFrameworkRegister javaAgentFrameworkRegister;

    public PowerMockStatement(Statement base, Object target, JavaAgentClassRegister agentClassRegister) {
        this.fNext = base;
        this.target = target;
        this.agentClassRegister = agentClassRegister;
        this.javaAgentFrameworkRegister = JavaAgentFrameworkRegisterFactory.create();
    }

    public void evaluate() throws Throwable {
        Object annotationEnabler = this.loadAnnotationEnableIfPresent();
        try {
            this.injectMocksUsingAnnotationEnabler(this.target, annotationEnabler);
            PowerMockStatement.registerProxyFramework();
            this.setFrameworkAgentClassRegister();
            this.fNext.evaluate();
        }
        finally {
            MockRepository.clear();
            this.clearMockFields(this.target, annotationEnabler);
            this.clearFrameworkAgentClassRegister();
        }
    }

    private void clearFrameworkAgentClassRegister() {
        this.agentClassRegister.clear();
        this.javaAgentFrameworkRegister.clear();
    }

    private void setFrameworkAgentClassRegister() {
        this.javaAgentFrameworkRegister.set(this.agentClassRegister);
    }

    private Object loadAnnotationEnableIfPresent() {
        boolean hasAnnotationEnabler = this.hasAnnotationEnablerClass();
        if (!hasAnnotationEnabler) {
            return null;
        }
        try {
            return Whitebox.invokeConstructor(Class.forName(ANNOTATION_ENABLER, true, Thread.currentThread().getContextClassLoader()), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error, failed to load annotation enabler.");
        }
    }

    private boolean hasAnnotationEnablerClass() {
        try {
            Class.forName(ANNOTATION_ENABLER, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void clearMockFields(Object target, Object annotationEnabler) throws Exception {
        if (annotationEnabler != null) {
            Class[] mockAnnotations = (Class[])Whitebox.invokeMethod((Object)annotationEnabler, (String)"getMockAnnotations", (Object[])new Object[0]);
            Set mockFields = Whitebox.getFieldsAnnotatedWith((Object)target, (Class[])mockAnnotations);
            for (Field field : mockFields) {
                field.set(target, null);
            }
        }
    }

    private void injectMocksUsingAnnotationEnabler(Object target, Object annotationEnabler) throws Exception {
        if (annotationEnabler != null) {
            Whitebox.invokeMethod((Object)annotationEnabler, (String)"beforeTestMethod", (Class[])new Class[]{Object.class, Method.class, Object[].class}, (Object[])new Object[]{target, null, null});
        }
    }

    private static void registerProxyFramework() {
        ClassLoaderRegisterProxyFramework.registerProxyframework((ClassLoader)Thread.currentThread().getContextClassLoader());
    }
}

