/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.locators.InternetExplorerLocator;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsProcessGroup;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;

public class HTABrowserLauncher
implements BrowserLauncher {
    static Logger log = Logger.getLogger(HTABrowserLauncher.class.getName());
    private String sessionId;
    private File dir;
    private String htaCommandPath;
    private WindowsProcessGroup htaProcess;
    private WindowsProcessGroup iexploreProcess;
    private RemoteControlConfiguration configuration;
    private Capabilities browserOptions;

    public HTABrowserLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        if (browserLaunchLocation == null) {
            browserLaunchLocation = HTABrowserLauncher.findHTALaunchLocation();
        }
        this.htaCommandPath = browserLaunchLocation;
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.browserOptions = configuration.copySettingsIntoBrowserOptions(browserOptions);
    }

    private static String findHTALaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("mshtaDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.findSystemRoot() + "\\system32\\mshta.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        String mshtaEXE = CommandLine.findExecutable((String)"mshta.exe");
        if (mshtaEXE != null) {
            return mshtaEXE;
        }
        throw new RuntimeException("MSHTA.exe couldn't be found in the path!\nPlease add the directory containing mshta.exe to your PATH environment\nvariable, or explicitly specify a path to mshta.exe like this:\n*mshta c:\\blah\\mshta.exe");
    }

    private void launch(String url, String htaName) {
        String query = LauncherUtils.getQueryString((String)url);
        query = query + "&baseUrl=http://localhost:" + this.getPort() + "/selenium-server/";
        this.createHTAFiles();
        String hta = new File(this.dir, "core/" + htaName).getAbsolutePath();
        log.info("Launching Embedded Internet Explorer...");
        this.iexploreProcess = new WindowsProcessGroup(new InternetExplorerLocator().findBrowserLocationOrFail().launcherFilePath(), new String[]{"-Embedding"});
        this.iexploreProcess.executeAsync();
        log.info("Launching Internet Explorer HTA...");
        this.htaProcess = new WindowsProcessGroup(this.htaCommandPath, new String[]{hta, query});
        this.htaProcess.executeAsync();
    }

    private void createHTAFiles() {
        this.dir = LauncherUtils.createCustomProfileDir((String)this.sessionId);
        File coreDir = new File(this.dir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(HTABrowserLauncher.class, "/core", coreDir);
            File selRunnerSrc = new File(coreDir, "RemoteRunner.html");
            File selRunnerDest = new File(coreDir, "RemoteRunner.hta");
            File testRunnerSrc = new File(coreDir, "TestRunner.html");
            File testRunnerDest = new File(coreDir, "TestRunner.hta");
            File userExt = this.configuration.getUserExtensions();
            if (userExt != null) {
                File selUserExt = new File(coreDir, "scripts/user-extensions.js");
                FileHandler.copy((File)userExt, (File)selUserExt);
            }
            FileHandler.copy((File)selRunnerSrc, (File)selRunnerDest);
            FileHandler.copy((File)testRunnerSrc, (File)testRunnerDest);
            this.writeSessionExtensionJs(coreDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSessionExtensionJs(File coreDir) throws IOException {
        FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getQueueSet(this.sessionId);
        if (queueSet.getExtensionJs().length() > 0) {
            String path = "scripts/user-extensions.js[" + this.sessionId + "]";
            FileWriter fileWriter = new FileWriter(new File(coreDir, path));
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(queueSet.getExtensionJs());
            writer.close();
            fileWriter.close();
        }
    }

    public void close() {
        int exitValue;
        if (this.browserOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName((String)"iexplore.exe");
        }
        if (this.browserOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName((String)"mshta.exe");
        }
        if (this.iexploreProcess != null && (exitValue = this.iexploreProcess.destroy()) == 0) {
            log.warning("Embedded iexplore seems to have ended on its own (did we kill the real browser???)");
        }
        if (this.htaProcess == null) {
            return;
        }
        this.htaProcess.destroy();
        LauncherUtils.recursivelyDeleteDir((File)this.dir);
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl((String)browserURL, (String)suiteUrl, (!BrowserOptions.isSingleWindow(this.browserOptions) ? 1 : 0) != 0, (int)this.getPort()), "TestRunner.hta");
    }

    private int getPort() {
        return this.configuration.getPortDriversShouldContact();
    }

    public void launchRemoteSession(String url) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl((String)url, (String)this.sessionId, (!BrowserOptions.isSingleWindow(this.browserOptions) ? 1 : 0) != 0, (int)this.getPort(), (boolean)this.browserOptions.is("browserSideLog")), "RemoteRunner.hta");
    }
}

