/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock;

import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

@Configuration
@EnableConfigurationProperties(value={BedrockAwsConnectionProperties.class})
public class BedrockAwsConnectionConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AwsCredentialsProvider credentialsProvider(BedrockAwsConnectionProperties properties) {
        if (StringUtils.hasText((String)properties.getAccessKey()) && StringUtils.hasText((String)properties.getSecretKey())) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)properties.getAccessKey(), (String)properties.getSecretKey()));
        }
        return DefaultCredentialsProvider.create();
    }
}

