/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.ollama;

import org.springframework.ai.autoconfigure.ollama.OllamaChatProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaConnectionProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaEmbeddingProperties;
import org.springframework.ai.ollama.OllamaChatClient;
import org.springframework.ai.ollama.OllamaEmbeddingClient;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={OllamaApi.class})
@EnableConfigurationProperties(value={OllamaChatProperties.class, OllamaEmbeddingProperties.class, OllamaConnectionProperties.class})
public class OllamaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OllamaApi ollamaApi(OllamaConnectionProperties properties, RestClient.Builder restClientBuilder) {
        return new OllamaApi(properties.getBaseUrl(), restClientBuilder);
    }

    @Bean
    public OllamaChatClient ollamaChatClient(OllamaApi ollamaApi, OllamaChatProperties properties) {
        return new OllamaChatClient(ollamaApi).withModel(properties.getModel()).withDefaultOptions(properties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public OllamaEmbeddingClient ollamaEmbeddingClient(OllamaApi ollamaApi, OllamaEmbeddingProperties properties) {
        return new OllamaEmbeddingClient(ollamaApi).withModel(properties.getModel()).withDefaultOptions(properties.getOptions());
    }
}

