/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import java.util.List;
import org.springframework.ai.autoconfigure.openai.OpenAiChatProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiImageProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.openai.OpenAiChatClient;
import org.springframework.ai.openai.OpenAiEmbeddingClient;
import org.springframework.ai.openai.OpenAiImageClient;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={OpenAiApi.class})
@EnableConfigurationProperties(value={OpenAiConnectionProperties.class, OpenAiChatProperties.class, OpenAiEmbeddingProperties.class, OpenAiImageProperties.class})
public class OpenAiAutoConfiguration {
    public static final String OPEN_AI_API_KEY_MUST_BE_SET = "OpenAI API key must be set";
    public static final String OPEN_AI_BASE_URL_MUST_BE_SET = "OpenAI base URL must be set";

    @Bean
    @ConditionalOnMissingBean
    public OpenAiChatClient openAiChatClient(OpenAiConnectionProperties commonProperties, OpenAiChatProperties chatProperties, RestClient.Builder restClientBuilder, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext) {
        String apiKey = StringUtils.hasText((String)chatProperties.getApiKey()) ? chatProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)chatProperties.getBaseUrl()) ? chatProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)OPEN_AI_API_KEY_MUST_BE_SET);
        Assert.hasText((String)baseUrl, (String)OPEN_AI_BASE_URL_MUST_BE_SET);
        OpenAiApi openAiApi = new OpenAiApi(baseUrl, apiKey, restClientBuilder);
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        return new OpenAiChatClient(openAiApi, chatProperties.getOptions(), functionCallbackContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public EmbeddingClient openAiEmbeddingClient(OpenAiConnectionProperties commonProperties, OpenAiEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder) {
        String apiKey = StringUtils.hasText((String)embeddingProperties.getApiKey()) ? embeddingProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)embeddingProperties.getBaseUrl()) ? embeddingProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)OPEN_AI_API_KEY_MUST_BE_SET);
        Assert.hasText((String)baseUrl, (String)OPEN_AI_BASE_URL_MUST_BE_SET);
        OpenAiApi openAiApi = new OpenAiApi(baseUrl, apiKey, restClientBuilder);
        return new OpenAiEmbeddingClient(openAiApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAiImageClient openAiImageClient(OpenAiConnectionProperties commonProperties, OpenAiImageProperties imageProperties, RestClient.Builder restClientBuilder) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)OPEN_AI_API_KEY_MUST_BE_SET);
        Assert.hasText((String)baseUrl, (String)OPEN_AI_BASE_URL_MUST_BE_SET);
        OpenAiImageApi openAiImageApi = new OpenAiImageApi(baseUrl, apiKey, restClientBuilder);
        return new OpenAiImageClient(openAiImageApi).withDefaultOptions(imageProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }
}

