/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.CircleCaptcha;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.util.Resps;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.vo.RequestExt;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.utils.cache.ICache;
import org.tio.utils.resp.Resp;

@RequestPath(value="/captcha")
public class CaptchaController {
    private static Logger log = LoggerFactory.getLogger(CaptchaController.class);

    public static Resp check(String captcha, HttpRequest request, boolean remove) {
        HttpSession session = request.getHttpSession();
        RequestExt ext = WebUtils.getRequestExt(request);
        boolean isNeed = ext.isFromBrowserPc();
        if (!isNeed) {
            return Resp.ok();
        }
        ICache cache = Caches.getCache((CacheConfig)CacheConfig.CAPTCHA);
        String code = (String)((Object)Caches.getCache((CacheConfig)CacheConfig.CAPTCHA).get(session.getId()));
        if (remove) {
            cache.remove(session.getId());
        }
        if (StrUtil.isNotBlank((CharSequence)captcha) && Objects.equals(captcha.toLowerCase(), code)) {
            return Resp.ok();
        }
        if (StrUtil.isNotBlank((CharSequence)code)) {
            return Resp.fail().msg("\u6821\u9a8c\u7801\u5931\u6548");
        }
        return Resp.fail().msg("\u8f93\u5165\u7684\u6821\u9a8c\u7801\u4e0d\u6b63\u786e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestPath(value="")
    public HttpResponse index(HttpRequest request) throws Exception {
        HttpResponse ret = null;
        try (ByteArrayOutputStream byteArrayOutputStream = null;){
            int width = 116;
            int height = 36;
            int length = 4;
            CircleCaptcha captcha = CaptchaUtil.createCircleCaptcha((int)width, (int)height, (int)length, (int)3);
            byteArrayOutputStream = new ByteArrayOutputStream();
            captcha.write((OutputStream)byteArrayOutputStream);
            byte[] bs = byteArrayOutputStream.toByteArray();
            String code = captcha.getCode();
            code = code.toLowerCase();
            Caches.getCache((CacheConfig)CacheConfig.CAPTCHA).put(request.getHttpSession().getId(), (Serializable)((Object)code));
            ret = Resps.bytes((HttpRequest)request, (byte[])bs, (String)"png");
        }
        return ret;
    }

    @RequestPath(value="/validate")
    public HttpResponse validate(String captcha, HttpRequest request) throws Exception {
        Resp resp = CaptchaController.check(captcha, request, false);
        HttpResponse response = Resps.json((HttpRequest)request, (Object)resp);
        return response;
    }
}

