/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.util.Resps;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.im.server.handler.wx.WxChatApi;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.LoginLog;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.mg.service.model.main.UserToken;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.LoginLogService;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.base.UserTokenService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.vo.RequestExt;
import org.tio.mg.service.vo.SessionExt;
import org.tio.mg.web.server.init.WebApiInit;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.mg.web.server.vo.LoginResult;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.utils.SystemTimer;
import org.tio.utils.resp.Resp;

@RequestPath(value="/login")
public class LoginController {
    private static Logger log = LoggerFactory.getLogger(LoginController.class);
    private UserService userService = UserService.ME;

    public static void main(String[] args) {
    }

    private Ret _login(String loginname, String pd5, String authcode, boolean isThirdLogin, User user, HttpRequest request) {
        Ret ret = null;
        if (user == null) {
            ret = this.userService.login(loginname, pd5, isThirdLogin);
            if (ret.isFail()) {
                Resp resp = Resp.fail();
                Integer code = (Integer)ret.get((Object)"code");
                if (code == 3) {
                    resp.code(Integer.valueOf(3));
                } else {
                    resp.code(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.code).msg(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.value);
                }
                HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
                return Ret.fail().set((Object)"resp", (Object)httpResponse);
            }
            user = (User)ret.get((Object)"user");
        }
        if (user != null) {
            Resp resp = LoginController.checkStatus(user);
            if (resp.isOk()) {
                return Ret.ok().set((Object)"user", (Object)user);
            }
            HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
            return Ret.fail().set((Object)"resp", (Object)httpResponse);
        }
        Resp resp = Resp.fail();
        resp.code(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.code).msg(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.value);
        HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
        return Ret.fail().set((Object)"resp", (Object)httpResponse);
    }

    private static Resp checkStatus(User user) {
        if (Objects.equals(user.getStatus(), (byte)1)) {
            return Resp.ok();
        }
        if (Objects.equals(user.getStatus(), (byte)5)) {
            return Resp.fail().code(LoginResult.ErrorCode.USER_INBLACK_ERROR.code).msg(LoginResult.ErrorCode.USER_INBLACK_ERROR.value);
        }
        return Resp.fail().code(LoginResult.ErrorCode.USER_STATUS_ERROR.code).msg(LoginResult.ErrorCode.USER_STATUS_ERROR.value);
    }

    @RequestPath(value="")
    public HttpResponse login(String loginname, String pd5, String authcode, HttpRequest request) throws Exception {
        Ret ret;
        loginname = StrUtil.trim((CharSequence)loginname);
        String sessionId = request.getHttpSession().getId();
        User user = null;
        HttpSession httpSession = request.getHttpSession();
        HttpConfig httpConfig = request.getHttpConfig();
        Boolean isThirdLogin = (Boolean)request.getAttribute("IS_THIRD_LOGIN", (Serializable)Boolean.valueOf(false));
        User userThirdLogin = null;
        if (isThirdLogin.booleanValue()) {
            userThirdLogin = (User)request.getAttribute("THIRD_LOGIN_USER", null);
        }
        if ((ret = this._login(loginname, pd5, authcode, isThirdLogin, userThirdLogin, request)).isOk()) {
            user = (User)ret.get((Object)"user");
            RequestExt requestExt = WebUtils.getRequestExt(request);
            byte deviceType = requestExt.getDeviceType();
            boolean fromApp = requestExt.isFromApp();
            String ip = request.getClientIp();
            IpInfo ipinfo = IpInfoService.ME.save(ip);
            LoginLog loginLog = new LoginLog();
            loginLog.setIp(ip);
            loginLog.setIpid(ipinfo.getId());
            loginLog.setSessionid(sessionId);
            loginLog.setUid(user.getId());
            loginLog.setDevicetype(Byte.valueOf(deviceType));
            loginLog.setTime(new Date());
            if (fromApp) {
                loginLog.setDeviceinfo(StringUtils.substring((String)requestExt.getDeviceinfo(), (int)0, (int)128));
                loginLog.setImei(requestExt.getImei());
                loginLog.setAppversion(requestExt.getAppVersion());
            } else {
                loginLog.setDeviceinfo(StringUtils.substring((String)request.getUserAgent(), (int)0, (int)128));
                UserAgent userAgent = requestExt.getUserAgent();
                if (userAgent != null && userAgent.getId() != null) {
                    loginLog.setUaid(userAgent.getId());
                }
            }
            LoginLogService.me.add(loginLog);
            HttpResponse httpResponse = null;
            if (isThirdLogin.booleanValue()) {
                httpResponse = (HttpResponse)request.getAttribute("THIRD_LOGIN_RESPONSE");
            }
            if (httpResponse == null) {
                httpResponse = Resps.json((HttpRequest)request, (Object)Resp.ok());
            }
            WebApiInit.requestHandler.updateSessionId(request, httpSession, httpResponse);
            String newSeesionId = request.getHttpSession().getId();
            UserToken userToken = UserTokenService.me.find((int)deviceType, user.getId().intValue());
            if (userToken == null) {
                userToken = new UserToken();
                userToken.setUid(user.getId());
                userToken.setDevicetype(Byte.valueOf(deviceType));
                userToken.setToken(newSeesionId);
                UserTokenService.me.add(userToken);
            } else {
                String oldToken = userToken.getToken();
                if (!Objects.equals(oldToken, sessionId)) {
                    HttpSession oldHttpSession = (HttpSession)httpConfig.getSessionStore().get(oldToken);
                    if (oldHttpSession != null && Objects.equals(MgConfService.getInt((String)"login.use.sso", (Integer)2), 1)) {
                        int kicktedCode = 1003;
                        if (Objects.equals(deviceType, Devicetype.PC.getValue())) {
                            kicktedCode = 1009;
                        } else if (Objects.equals(deviceType, Devicetype.H5.getValue())) {
                            kicktedCode = 1010;
                        }
                        WxChatApi.sendFriendErrorMsg((Byte)deviceType, (String)sessionId, (String)ip, (Integer)user.getId(), (Integer)user.getId(), (Integer)user.getId(), null, (Integer)kicktedCode, (String)"\u5f53\u524d\u8d26\u53f7\u5df2\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55");
                        SessionExt oldSessionExt = (SessionExt)oldHttpSession.getAttribute("SESSION_EXT", SessionExt.class, (Serializable)new SessionExt(), httpConfig);
                        oldSessionExt.setUid(null);
                        oldSessionExt.setKickedInfo(null);
                        oldHttpSession.update(httpConfig);
                    }
                    userToken.setToken(newSeesionId);
                    UserTokenService.me.update(userToken);
                }
            }
            SessionExt sessionExt = (SessionExt)httpSession.getAttribute("SESSION_EXT", SessionExt.class);
            sessionExt.setUid(user.getId());
            sessionExt.setLoginTime(Long.valueOf(SystemTimer.currTime));
            httpSession.update(httpConfig);
            return httpResponse;
        }
        HttpResponse httpResponse = (HttpResponse)ret.get((Object)"resp");
        if (httpResponse == null) {
            log.error("_login(loginname, pwd, authcode, request)\u8fd4\u56de\u503c\u6ca1\u6709\u5305\u542bresponse\u4fe1\u606f");
            return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38"));
        }
        return httpResponse;
    }
}

