/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.util.Resps;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.mg.service.model.mg.MgIpInfo;
import org.tio.mg.service.model.mg.MgOperLog;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.model.mg.MgUserLoginLog;
import org.tio.mg.service.model.mg.MgUserToken;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.service.mg.MgUserService;
import org.tio.mg.service.service.mg.MgUserTokenService;
import org.tio.mg.service.utils.PeriodUtils;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.MgConst;
import org.tio.mg.service.vo.RequestExt;
import org.tio.mg.service.vo.SessionExt;
import org.tio.mg.web.server.init.WebApiInit;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.mg.web.server.vo.LoginResult;
import org.tio.utils.SystemTimer;
import org.tio.utils.jfinal.P;
import org.tio.utils.resp.Resp;

@RequestPath(value="/mglogin")
public class MgLoginController {
    private static Logger log = LoggerFactory.getLogger(MgLoginController.class);
    private MgUserService userService = MgUserService.ME;

    public static void main(String[] args) {
    }

    private Ret _login(String loginname, String pd5, String authcode, HttpRequest request) {
        Ret ret = null;
        MgUser user = null;
        ret = this.userService.login(loginname, pd5);
        if (ret.isFail()) {
            Resp resp = Resp.fail();
            Integer code = (Integer)ret.get((Object)"code");
            if (code == 3) {
                resp.code(Integer.valueOf(3));
            } else {
                resp.code(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.code).msg(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.value);
            }
            HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
            return Ret.fail().set((Object)"resp", (Object)httpResponse);
        }
        user = (MgUser)RetUtils.getOkTData((Ret)ret);
        if (user != null) {
            Resp resp = MgLoginController.checkStatus(user);
            if (resp.isOk()) {
                return Ret.ok().set((Object)"user", (Object)user);
            }
            HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
            return Ret.fail().set((Object)"resp", (Object)httpResponse);
        }
        Resp resp = Resp.fail();
        resp.code(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.code).msg(LoginResult.ErrorCode.USER_OR_PWD_ERROR_PWD.value);
        HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)resp);
        return Ret.fail().set((Object)"resp", (Object)httpResponse);
    }

    private static Resp checkStatus(MgUser user) {
        if (Objects.equals(user.getStatus(), (byte)1)) {
            return Resp.ok();
        }
        if (Objects.equals(user.getStatus(), (byte)5)) {
            return Resp.fail().code(LoginResult.ErrorCode.USER_INBLACK_ERROR.code).msg(LoginResult.ErrorCode.USER_INBLACK_ERROR.value);
        }
        return Resp.fail().code(LoginResult.ErrorCode.USER_STATUS_ERROR.code).msg(LoginResult.ErrorCode.USER_STATUS_ERROR.value);
    }

    @RequestPath(value="")
    public HttpResponse login(String loginname, String pd5, String authcode, HttpRequest request) throws Exception {
        loginname = StrUtil.trim((CharSequence)loginname);
        String sessionId = request.getHttpSession().getId();
        MgUser user = null;
        HttpSession httpSession = request.getHttpSession();
        HttpConfig httpConfig = request.getHttpConfig();
        Ret ret = this._login(loginname, pd5, authcode, request);
        if (ret.isOk()) {
            user = (MgUser)ret.get((Object)"user");
            RequestExt requestExt = WebUtils.getRequestExt(request);
            byte deviceType = requestExt.getDeviceType();
            boolean fromApp = requestExt.isFromApp();
            String ip = request.getClientIp();
            MgIpInfo ipinfo = IpInfoService.ME.mgSave(ip);
            MgOperLog operLog = new MgOperLog();
            operLog.setModename("\u767b\u5f55");
            operLog.setAid(Integer.valueOf(-1));
            operLog.setOperip(ip);
            operLog.setOperparam(loginname + "****" + authcode);
            operLog.setOpertype(MgConst.OperLogType.SYS);
            if (fromApp) {
                operLog.setDeviceinfo(StringUtils.substring((String)requestExt.getDeviceinfo(), (int)0, (int)128));
            } else {
                operLog.setDeviceinfo(StringUtils.substring((String)request.getUserAgent(), (int)0, (int)128));
            }
            operLog.save();
            MgUserLoginLog userLoginLog = new MgUserLoginLog();
            Date time = new Date();
            userLoginLog.setIp(ip);
            userLoginLog.setIpid(ipinfo.getId());
            userLoginLog.setSessionid(sessionId);
            userLoginLog.setMguid(user.getId());
            userLoginLog.setDevicetype(Byte.valueOf(deviceType));
            userLoginLog.setDayperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)1));
            userLoginLog.setTimeperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)7));
            userLoginLog.setHourperiod(PeriodUtils.dateToPeriodByType((Date)time, (byte)6));
            userLoginLog.setTime(time);
            if (fromApp) {
                userLoginLog.setDeviceinfo(StringUtils.substring((String)requestExt.getDeviceinfo(), (int)0, (int)128));
                userLoginLog.setImei(requestExt.getImei());
            } else {
                UserAgent userAgent = requestExt.getUserAgent();
                if (userAgent != null) {
                    userLoginLog.setDeviceinfo(userAgent.getOsName() + " " + userAgent.getOsVersion() + "/" + userAgent.getAgentName() + " " + userAgent.getAgentVersionMajor());
                } else {
                    userLoginLog.setDeviceinfo(StringUtils.substring((String)request.getUserAgent(), (int)0, (int)128));
                }
            }
            userLoginLog.save();
            HttpResponse httpResponse = Resps.json((HttpRequest)request, (Object)Resp.ok());
            WebApiInit.requestHandler.updateSessionId(request, httpSession, httpResponse);
            String newSeesionId = request.getHttpSession().getId();
            MgUserToken userToken = MgUserTokenService.me.find((int)deviceType, user.getId().intValue());
            if (userToken == null) {
                userToken = new MgUserToken();
                userToken.setMguid(user.getId());
                userToken.setDevicetype(Byte.valueOf(deviceType));
                userToken.setToken(newSeesionId);
                MgUserTokenService.me.add(userToken);
            } else {
                boolean allowOper;
                String oldToken = userToken.getToken();
                if (!Objects.equals(oldToken, sessionId) && (allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true).booleanValue())) {
                    HttpSession oldHttpSession = (HttpSession)httpConfig.getSessionStore().get(oldToken);
                    if (oldHttpSession != null && Objects.equals(MgConfService.getInt((String)"login.use.sso", (Integer)2), 1)) {
                        SessionExt oldSessionExt = (SessionExt)oldHttpSession.getAttribute("SESSION_EXT", SessionExt.class, (Serializable)new SessionExt(), httpConfig);
                        oldSessionExt.setUid(null);
                        oldSessionExt.setKickedInfo(operLog);
                        oldHttpSession.update(httpConfig);
                    }
                    userToken.setToken(newSeesionId);
                    MgUserTokenService.me.update(userToken);
                }
            }
            SessionExt sessionExt = (SessionExt)httpSession.getAttribute("SESSION_EXT", SessionExt.class);
            sessionExt.setUid(user.getId());
            sessionExt.setLoginTime(Long.valueOf(SystemTimer.currTime));
            httpSession.update(httpConfig);
            return httpResponse;
        }
        HttpResponse httpResponse = (HttpResponse)ret.get((Object)"resp");
        if (httpResponse == null) {
            log.error("_login(loginname, pwd, authcode, request)\u8fd4\u56de\u503c\u6ca1\u6709\u5305\u542bresponse\u4fe1\u606f");
            return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u670d\u52a1\u5668\u5f02\u5e38"));
        }
        return httpResponse;
    }
}

