/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base.thirdlogin.provider;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.util.Resps;
import org.tio.mg.service.model.main.UserThird;
import org.tio.mg.web.server.controller.base.thirdlogin.IThirdLogin;

public abstract class Auth2Login
implements IThirdLogin {
    private static Logger log = LoggerFactory.getLogger(Auth2Login.class);
    public static final String STATE_KEY = "THIRD_LOGIN_STATE_KEY";

    public static void main(String[] args) {
    }

    @Override
    public HttpResponse toLoginPage(HttpRequest request, Integer type) throws Exception {
        HttpSession session = request.getHttpSession();
        String state = IdUtil.simpleUUID();
        String url = this.loginUrl(request, type, state);
        if (StrUtil.isNotBlank((CharSequence)url)) {
            session.setAttribute(STATE_KEY, (Serializable)((Object)state), request.getHttpConfig());
            return Resps.redirect((HttpRequest)request, (String)url);
        }
        request.close();
        return null;
    }

    public abstract String loginUrl(HttpRequest var1, Integer var2, String var3) throws Exception;

    @Override
    public UserThird callback(HttpRequest request, Integer type) throws Exception {
        String state = request.getParam("state");
        String code = request.getParam("code");
        if (StrUtil.isBlank((CharSequence)state)) {
            request.close();
            return null;
        }
        HttpSession session = request.getHttpSession();
        String sessionState = (String)session.getAttribute(STATE_KEY, String.class);
        session.removeAttribute(STATE_KEY, request.getHttpConfig());
        log.error("{}, code:{}", (Object)this.getClass().getSimpleName(), (Object)code);
        if (!Objects.equals(state, sessionState)) {
            request.close();
            return null;
        }
        UserThird userThird = this.getUserThird(request, type, state, code);
        userThird.setType(type);
        userThird.setTime(new Date());
        return userThird;
    }

    public abstract UserThird getUserThird(HttpRequest var1, Integer var2, String var3, String var4) throws Exception;

    @Override
    public boolean isAjax(HttpRequest request, Integer type) throws Exception {
        return false;
    }
}

