/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.tiosite;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.model.main.File;
import org.tio.mg.service.model.mg.MgInvoice;
import org.tio.mg.service.model.mg.MgInvoiceReimbursement;
import org.tio.mg.service.model.mg.MgReimburseCode;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.service.InvoiceService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.web.server.utils.UploadUtils;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.resp.Resp;

@RequestPath(value="/invoice")
public class InvoiceController {
    private static Logger log = LoggerFactory.getLogger(InvoiceController.class);
    private InvoiceService invoiceService = InvoiceService.me;

    public static void main(String[] args) {
    }

    @RequestPath(value="/invoicelist")
    public Resp invoiceList(HttpRequest request, Integer pageNumber, Integer pageSize, Integer mguid, Byte status, Byte paytype, Byte type, Byte developstatus) throws Exception {
        Ret ret = this.invoiceService.invoiceList(pageNumber, pageSize, mguid, status, paytype, type, developstatus);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/userinvoicelist")
    public Resp userInvoiceList(HttpRequest request, Integer pageNumber, Integer pageSize, Byte paytype, Byte type) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        Ret ret = this.invoiceService.userInvoiceList(pageNumber, pageSize, curr.getId(), paytype, type);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/users")
    public Resp users(HttpRequest request) throws Exception {
        Ret ret = this.invoiceService.users();
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/updatestatus")
    public Resp updatestatus(HttpRequest request, Integer id, Byte status) throws Exception {
        Ret ret = this.invoiceService.update(id, status, null, "");
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/develop")
    public Resp develop(HttpRequest request, Integer id, Byte developstatus, String developcode) throws Exception {
        Ret ret = this.invoiceService.update(id, null, developstatus, developcode);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/total")
    public Resp total(HttpRequest request, Integer mguid, Byte status, Byte paytype, Byte type, Byte developstatus) throws Exception {
        Ret ret = this.invoiceService.total(mguid, status, paytype, type, developstatus);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u91d1\u989d\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/usertotal")
    public Resp usertotal(HttpRequest request, Byte paytype, Byte type) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        Ret ret = this.invoiceService.userTotal(curr.getId(), paytype, type);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u91d1\u989d\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/batchupdate")
    public Resp batchUpdate(HttpRequest request, String ids, Byte status) throws Exception {
        Ret ret = this.invoiceService.batchupdate(ids, status);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, MgInvoice invoice, UploadFile uploadFile) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        if (invoice == null) {
            return Resp.fail((String)"\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        invoice.setUploadtime(new Date());
        invoice.setMguid(curr.getId());
        if (uploadFile == null) {
            return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (invoice.getAmount() == null || invoice.getAmount() <= 0.0) {
            return Resp.fail((String)"\u53d1\u7968\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        File dbFile = InvoiceController.innerUploadFile(uploadFile, curr, invoice);
        invoice.setFileurl(dbFile.getUrl());
        Ret ret = InvoiceService.me.add(invoice);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/addreimburse")
    public Resp addReimburse(HttpRequest request, MgInvoiceReimbursement reimbursement, String ids) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        if (reimbursement == null || reimbursement.getMguid() == null) {
            return Resp.fail().msg("\u65e0\u6548\u53c2\u6570");
        }
        reimbursement.setOperuid(curr.getId());
        Ret ret = this.invoiceService.addReimburse(reimbursement, ids);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/updateremark")
    public Resp updateRemark(HttpRequest request, MgInvoice invoice) throws Exception {
        Ret ret = this.invoiceService.updateRemark(invoice);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/updatereimburse")
    public Resp updateReimburse(HttpRequest request, MgInvoiceReimbursement reimbursement, String ids) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        Ret ret = this.invoiceService.updateReimburse(reimbursement, ids, curr.getId());
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/upload")
    public Resp upload(HttpRequest request, Integer rid) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        Ret ret = this.invoiceService.upload(rid, curr.getId());
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/delreimburseinvoice")
    public Resp delreimburseinvoice(HttpRequest request, Integer id, Integer rid) throws Exception {
        Ret ret = this.invoiceService.delreimburseinvoice(id, rid);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/delreimburse")
    public Resp delreimburse(HttpRequest request, Integer rid) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        Ret ret = this.invoiceService.delreimburse(rid, curr.getId());
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/reimburselist")
    public Resp reimburseList(HttpRequest request, Integer pageNumber, Integer pageSize, String code) throws Exception {
        Ret ret = this.invoiceService.reimburseList(pageNumber, pageSize, code);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/reimbursedict")
    public Resp reimburseDict(HttpRequest request) throws Exception {
        List mgInvoices = this.invoiceService.reimburseDict();
        return Resp.ok((Object)mgInvoices);
    }

    @RequestPath(value="/reimburseinfo")
    public Resp reimburseInfo(HttpRequest request, String code) throws Exception {
        Ret ret = this.invoiceService.reimburseInfo(code);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/getrcode")
    public Resp getRcode(HttpRequest request) throws Exception {
        MgReimburseCode code = this.invoiceService.getCode(true);
        if (code == null) {
            return Resp.fail((String)"\u5206\u914d\u5355\u53f7\u5931\u8d25");
        }
        return Resp.ok((Object)code);
    }

    @RequestPath(value="/invoiceoutreimburselist")
    public Resp invoiceOutReimburseList(HttpRequest request, Integer pageNumber, Integer pageSize, Integer mguid, String starttime, String endtime) throws Exception {
        Ret ret = this.invoiceService.invoiceOutReimburseList(pageNumber, pageSize, mguid, starttime, endtime);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/invoicereimburselist")
    public Resp invoiceReimburseList(HttpRequest request, Integer pageNumber, Integer pageSize, String code) throws Exception {
        Ret ret = this.invoiceService.invoiceReimburseList(pageNumber, pageSize, code);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, MgInvoice invoice, UploadFile uploadFile) throws Exception {
        MgUser curr = WebUtils.currUser(request);
        if (invoice == null) {
            return Resp.fail((String)"\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (uploadFile != null) {
            File dbFile = InvoiceController.innerUploadFile(uploadFile, curr, invoice);
            invoice.setFileurl(dbFile.getUrl());
        }
        if (invoice.getAmount() == null || invoice.getAmount() <= 0.0) {
            return Resp.fail((String)"\u53d1\u7968\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        Ret ret = InvoiceService.me.update(invoice);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail().msg(RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    private static File innerUploadFile(UploadFile uploadFile, MgUser curr, MgInvoice invoice) throws Exception {
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String ext = FileUtil.extName((String)filename);
        String urlWithoutExt = UploadUtils.invoice("tio/invoice", curr.getNick(), invoice);
        String url = urlWithoutExt + "." + ext;
        java.io.File file = new java.io.File(Const.RES_ROOT, url);
        FileUtil.writeBytes((byte[])bs, (java.io.File)file);
        File dbFile = new File();
        dbFile.setExt(ext);
        dbFile.setFilename(uploadFile.getName());
        dbFile.setSize(Long.valueOf(bs.length));
        dbFile.setUid(Integer.valueOf(-666));
        dbFile.setUrl(url);
        dbFile.save();
        return dbFile;
    }
}

