/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.http;

import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.common.session.limiter.SessionRateVo;
import org.tio.mg.service.service.conf.IpWhiteListService;
import org.tio.utils.SystemTimer;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WebApiSessionRateLimiter
implements SessionRateLimiter {
    private static Logger log = LoggerFactory.getLogger(WebApiSessionRateLimiter.class);
    public static final WebApiSessionRateLimiter me = new WebApiSessionRateLimiter();
    private final Map<String, Integer> intervalMap = new HashMap<String, Integer>();
    private final Map<String, Integer> prefixMap = new HashMap<String, Integer>();
    private final Map<String, Integer> allowCountMap = new HashMap<String, Integer>();
    private HttpResponse response;

    private WebApiSessionRateLimiter() {
        this.prefixMap.put("/product/download/", 120000);
        this.allowCountMap.put("/tiomsg/groupmodelist", 9999);
        this.allowCountMap.put("/tiouser/statlist", 9999);
        this.allowCountMap.put("/tiomsg/grouplist", 9999);
        this.allowCountMap.put("/friend/fdlist", 9999);
        this.allowCountMap.put("/tiomsg/p2plist", 9999);
        this.response = new HttpResponse();
        try {
            this.response.setBody(Json.toJson((Object)Resp.fail((String)"\u5c0f\u5144Dei\uff0c\u4f60\u7684\u624b\u901f\u6709\u70b9\u5feb\uff0c\u5355\u8eab\u591a\u5c11\u5e74\u4e86\uff1f").code(Integer.valueOf(1005))).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        this.response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_JSON);
    }

    public boolean allow(HttpRequest request, SessionRateVo sessionRateVo) {
        if (IpWhiteListService.isWhiteIp((String)request.getClientIp())) {
            return true;
        }
        String path = request.getRequestLine().getPath();
        Integer allowCount = this.allowCountMap.get(path);
        if (allowCount == null) {
            allowCount = 120;
        }
        if (sessionRateVo.getAccessCount().get() > allowCount) {
            return false;
        }
        Integer iv = this.intervalMap.get(path);
        if (iv == null && this.prefixMap.size() > 0) {
            Set<Map.Entry<String, Integer>> set = this.prefixMap.entrySet();
            for (Map.Entry<String, Integer> entry : set) {
                if (!StrUtil.startWith((CharSequence)path, (CharSequence)entry.getKey())) continue;
                iv = entry.getValue();
                break;
            }
        }
        return iv == null || SystemTimer.currTime - sessionRateVo.getLastAccessTime() >= (long)iv.intValue();
    }

    public HttpResponse response(HttpRequest request, SessionRateVo sessionRateVo) {
        return this.response;
    }
}

