/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.http.stat.token;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.stat.token.TokenAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.mg.service.model.stat.TioTokenPathAccessStat;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.TioTokenPathAccessStatService;
import org.tio.mg.service.service.conf.IpWhiteListService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.web.server.http.WebApiHttpSessionListener;
import org.tio.mg.web.server.utils.TioIpPullblackUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.json.Json;
import org.tio.utils.lock.MapWithLock;

public class TioSiteTokenPathAccessStatListener
implements TokenPathAccessStatListener {
    private static Logger log = LoggerFactory.getLogger(TioSiteTokenPathAccessStatListener.class);
    public static final TioSiteTokenPathAccessStatListener ME_SITE_VIEW = new TioSiteTokenPathAccessStatListener(9);
    public static final TioSiteTokenPathAccessStatListener ME_SITE_API = new TioSiteTokenPathAccessStatListener(8);
    private byte appType = (byte)9;
    private static Set<String> skipExtSet = new HashSet<String>();
    private static final String CONF_PREFIX = "token.access.";
    private static final int STEP;
    private static final int G1_MAX_COUNT;
    private static final int G1_MAX_PER_SECOND;
    private static final int G2_MAX_COUNT;
    private static final int G2_MAX_PER_SECOND;

    public TioTokenPathAccessStat toDbObj(TokenAccessStat tokenAccessStat) {
        TioTokenPathAccessStat ret = new TioTokenPathAccessStat();
        int requestCount = tokenAccessStat.count.get();
        long timeCost = tokenAccessStat.timeCost.get();
        long duration = tokenAccessStat.getDuration();
        String uidStr = tokenAccessStat.getUid();
        if (StrUtil.isNotBlank((CharSequence)uidStr)) {
            ret.setUid(Integer.valueOf(Integer.parseInt(uidStr)));
        }
        ret.setToken(tokenAccessStat.getToken());
        ret.setAppType(Byte.valueOf(this.appType));
        ret.setRequestCount(Integer.valueOf(requestCount));
        ret.setTimeCost(Long.valueOf(timeCost));
        ret.setTimeCostPerRequest(Double.valueOf((double)timeCost / (double)requestCount));
        ret.setDuration(Long.valueOf(duration));
        ret.setDurationType(tokenAccessStat.getDurationType());
        ret.setFirstAccessTime(new Date(tokenAccessStat.getFirstAccessTime()));
        ret.setFormatedDuration(tokenAccessStat.getFormatedDuration());
        ret.setIp(tokenAccessStat.getIp());
        ret.setIpid(IpInfoService.ME.save(tokenAccessStat.getIp()).getId());
        ret.setPath(null);
        ret.setRequestCountPerSecond(Double.valueOf(tokenAccessStat.getPerSecond()));
        ret.setServer(Const.MY_IP);
        return ret;
    }

    public TioTokenPathAccessStat toDbObj(TokenPathAccessStat tokenPathAccessStat) {
        TioTokenPathAccessStat ret = new TioTokenPathAccessStat();
        int requestCount = tokenPathAccessStat.count.get();
        long timeCost = tokenPathAccessStat.timeCost.get();
        long duration = tokenPathAccessStat.getDuration();
        String uidStr = tokenPathAccessStat.getUid();
        if (StrUtil.isNotBlank((CharSequence)uidStr)) {
            ret.setUid(Integer.valueOf(Integer.parseInt(uidStr)));
        }
        ret.setToken(tokenPathAccessStat.getToken());
        ret.setAppType(Byte.valueOf(this.appType));
        ret.setRequestCount(Integer.valueOf(requestCount));
        ret.setTimeCost(Long.valueOf(timeCost));
        ret.setTimeCostPerRequest(Double.valueOf((double)timeCost / (double)requestCount));
        ret.setDuration(Long.valueOf(duration));
        ret.setDurationType(tokenPathAccessStat.getDurationType());
        ret.setFirstAccessTime(new Date(tokenPathAccessStat.getFirstAccessTime()));
        ret.setFormatedDuration(tokenPathAccessStat.getFormatedDuration());
        ret.setIp(tokenPathAccessStat.getIp());
        ret.setIpid(IpInfoService.ME.save(tokenPathAccessStat.getIp()).getId());
        ret.setPath(tokenPathAccessStat.getPath());
        if (Objects.equals(this.appType, (byte)8)) {
            ret.setRestype("api");
        } else {
            String ext = FileUtil.extName((String)tokenPathAccessStat.getPath());
            if (StrUtil.isNotBlank((CharSequence)ext)) {
                ret.setRestype(ext);
            }
        }
        ret.setRequestCountPerSecond(Double.valueOf(tokenPathAccessStat.getPerSecond()));
        ret.setServer(Const.MY_IP);
        return ret;
    }

    public TioSiteTokenPathAccessStatListener(byte appType) {
        this.appType = appType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpired(TioConfig tioConfig, String token, TokenAccessStat tokenAccessStat) {
        if (Objects.equals(tokenAccessStat.getDurationType(), Const.TokenPathAccessStatDuration.DURATION_2)) {
            TioTokenPathAccessStat tioTokenAccessStat = this.toDbObj(tokenAccessStat);
            TioTokenPathAccessStatService.ME.save(tioTokenAccessStat);
            MapWithLock tokenPathAccessStatMap = tokenAccessStat.getTokenPathAccessStatMap();
            if (tokenPathAccessStatMap != null) {
                ReentrantReadWriteLock.ReadLock readLock = tokenPathAccessStatMap.readLock();
                readLock.lock();
                try {
                    Set set;
                    Map map = (Map)tokenPathAccessStatMap.getObj();
                    if (map != null && (set = map.entrySet()).size() > 0) {
                        ArrayList<TioTokenPathAccessStat> modelList = new ArrayList<TioTokenPathAccessStat>();
                        for (Map.Entry entry : set) {
                            TioTokenPathAccessStat tioTokenPathAccessStat = null;
                            try {
                                TokenPathAccessStat tokenPathAccessStat = (TokenPathAccessStat)entry.getValue();
                                String path = tokenPathAccessStat.getPath();
                                String ext = FileUtil.extName((String)path);
                                if (skipExtSet.contains(ext)) continue;
                                tioTokenPathAccessStat = this.toDbObj(tokenPathAccessStat);
                                modelList.add(tioTokenPathAccessStat);
                            }
                            catch (Exception e) {
                                log.error(Json.toFormatedJson(tioTokenPathAccessStat), (Throwable)e);
                            }
                        }
                        TioTokenPathAccessStatService.ME.batchSave(modelList);
                    }
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
                finally {
                    readLock.unlock();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("token:{}, \r\ntokenAccessStat:{} ", (Object)token, (Object)Json.toFormatedJson((Object)tokenAccessStat));
            }
        }
    }

    public boolean onChanged(HttpRequest httpRequest, String token, String path, TokenAccessStat tokenAccessStat, TokenPathAccessStat tokenPathAccessStat) {
        boolean isOk;
        if (IpWhiteListService.isWhiteIp((String)httpRequest.getClientIp())) {
            return true;
        }
        int allcount = tokenAccessStat.count.get();
        if (allcount % STEP != 0) {
            return true;
        }
        log.debug("token:{}, path:{}", (Object)token, (Object)path);
        String remark = null;
        String ip1 = tokenAccessStat.getIp();
        String ip = httpRequest.getClientIp();
        if (!StrUtil.equals((CharSequence)ip1, (CharSequence)ip)) {
            // empty if block
        }
        double preSecond = tokenAccessStat.getPerSecond();
        boolean g1 = false;
        boolean g2 = false;
        boolean g1_c1 = allcount > G1_MAX_COUNT;
        boolean g1_c2 = preSecond > (double)G1_MAX_PER_SECOND;
        boolean bl = g1 = g1_c1 && g1_c2;
        if (g1) {
            remark = "token\u3010" + token + "\u3011\u8bbf\u95ee\u8fdd\u53cd\u6761\u4ef6\u7ec41\uff1a\u603b\u8bbf\u95ee\u6b21\u6570" + allcount + "( > " + G1_MAX_COUNT + "), \u5e73\u5747\u6bcf\u79d2\u8bbf\u95ee" + preSecond + "\u6b21 (>" + G1_MAX_PER_SECOND + ")\uff0c\u62c9\u9ed1\u65f6\u8bbf\u95ee\u7684\u5730\u5740\u662f\uff1a\u3010" + path + "\u3011";
            this.pullBlack(httpRequest, tokenAccessStat, tokenPathAccessStat, remark);
            return false;
        }
        boolean g2_c1 = allcount > G2_MAX_COUNT;
        boolean g2_c2 = preSecond > (double)G2_MAX_PER_SECOND;
        boolean bl2 = g2 = g2_c1 && g2_c2;
        if (g2) {
            remark = "token\u3010" + token + "\u3011\u8bbf\u95ee\u8fdd\u53cd\u6761\u4ef6\u7ec42\uff1a\u603b\u8bbf\u95ee\u6b21\u6570" + allcount + "( > " + G2_MAX_COUNT + "), \u5e73\u5747\u6bcf\u79d2\u8bbf\u95ee" + preSecond + "\u6b21 (>" + G2_MAX_PER_SECOND + ")\uff0c\u62c9\u9ed1\u65f6\u8bbf\u95ee\u7684\u5730\u5740\u662f\uff1a\u3010" + path + "\u3011";
            this.pullBlack(httpRequest, tokenAccessStat, tokenPathAccessStat, remark);
            return false;
        }
        String sessionId = DefaultHttpRequestHandler.getSessionId((HttpRequest)httpRequest);
        if (!StrUtil.isNotBlank((CharSequence)sessionId) || !(isOk = WebApiHttpSessionListener.isValidSessionId(sessionId))) {
            // empty if block
        }
        return true;
    }

    public void pullBlack(HttpRequest request, TokenAccessStat tokenAccessStat, TokenPathAccessStat tokenPathAccessStat, String remark) {
        TioTokenPathAccessStat tioTokenAccessStat = this.toDbObj(tokenAccessStat);
        TioTokenPathAccessStatService.ME.save(tioTokenAccessStat);
        TioIpPullblackUtils.addToBlack(request, request.getClientIp(), remark, (byte)1);
        request.close();
    }

    public static void main(String[] args) {
    }

    public byte getAppType() {
        return this.appType;
    }

    public void setAppType(byte appType) {
        this.appType = appType;
    }

    static {
        skipExtSet.add("css");
        skipExtSet.add("js");
        skipExtSet.add("ico");
        skipExtSet.add("png");
        skipExtSet.add("jpg");
        skipExtSet.add("swf");
        skipExtSet.add("xml");
        skipExtSet.add("gif");
        skipExtSet.add("jpeg");
        skipExtSet.add("woff");
        skipExtSet.add("map");
        skipExtSet.add("txt");
        skipExtSet.add("mp4");
        skipExtSet.add("m3u8");
        skipExtSet.add("svg");
        STEP = MgConfService.getInt((String)"token.access.STEP", (Integer)200);
        G1_MAX_COUNT = MgConfService.getInt((String)"token.access.G1_MAX_COUNT", (Integer)200);
        G1_MAX_PER_SECOND = MgConfService.getInt((String)"token.access.G1_MAX_PER_SECOND", (Integer)5);
        G2_MAX_COUNT = MgConfService.getInt((String)"token.access.G2_MAX_COUNT", (Integer)100);
        G2_MAX_PER_SECOND = MgConfService.getInt((String)"token.access.G2_MAX_PER_SECOND", (Integer)10);
    }
}

