/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.init;

import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.core.stat.IpStatListener;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.id.impl.SnowflakeSessionIdGenerator;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.server.HttpServerStarter;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.intf.CurrUseridGetter;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.ThrowableHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.session.DomainSessionCookieDecorator;
import org.tio.http.server.session.HttpSessionListener;
import org.tio.http.server.session.SessionCookieDecorator;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStats;
import org.tio.http.server.stat.token.TokenGetter;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.http.server.stat.token.TokenPathAccessStats;
import org.tio.mg.service.init.PropInit;
import org.tio.mg.service.init.RedisInit;
import org.tio.mg.service.tio.TioSiteIpStatListener;
import org.tio.mg.web.server.WebApiRoot;
import org.tio.mg.web.server.auth.AccessCtrlConfig;
import org.tio.mg.web.server.http.TioSiteThrowableHandler;
import org.tio.mg.web.server.http.WebApiHttpServerInterceptor;
import org.tio.mg.web.server.http.WebApiHttpSessionListener;
import org.tio.mg.web.server.http.WebApiSessionRateLimiter;
import org.tio.mg.web.server.http.stat.TioSiteStatPathFilter;
import org.tio.mg.web.server.http.stat.ip.TioSiteIpPathAccessStatListener;
import org.tio.mg.web.server.http.stat.token.TioSiteCurrUseridGetter;
import org.tio.mg.web.server.http.stat.token.TioSiteTokenGetter;
import org.tio.mg.web.server.http.stat.token.TioSiteTokenPathAccessStatListener;
import org.tio.mg.web.server.init.HttpcacheInit;
import org.tio.server.ServerTioConfig;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.Threads;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WebApiInit {
    private static Logger log = LoggerFactory.getLogger(WebApiInit.class);
    public static HttpServerStarter httpServerStarter;
    public static ServerTioConfig serverTioConfig;
    public static HttpConfig httpConfig;
    public static Routes routes;
    public static DefaultHttpRequestHandler requestHandler;
    public static SnowflakeSessionIdGenerator sessionIdGenerator;

    public static void init() throws Exception {
        boolean isWebApiUseSsl;
        Integer max_length_of_post_body;
        Integer max_length_of_multi_body;
        PropInit.init();
        int port = P.getInt((String)"http.api.port");
        long sessionTimeout = P.getLong((String)"http.session.timeout", (Long)1800L);
        String contextpath = Const.API_CONTEXTPATH;
        String suffix = Const.API_SUFFIX;
        httpConfig = new HttpConfig(Integer.valueOf(port), Long.valueOf(sessionTimeout), contextpath, suffix);
        httpConfig.setSessionCacheName(P.get((String)"http.session.cache.name", (String)"tio-h-s"));
        Integer maxLiveTimeOfStaticRes = P.getInt((String)"http.maxLiveTimeOfStaticRes");
        if (maxLiveTimeOfStaticRes != null) {
            httpConfig.setMaxLiveTimeOfStaticRes(maxLiveTimeOfStaticRes.intValue());
        }
        if ((max_length_of_multi_body = P.getInt((String)"http.max_length_of_multi_body")) != null) {
            httpConfig.setMaxLengthOfMultiBody(max_length_of_multi_body * 1024);
        }
        if ((max_length_of_post_body = P.getInt((String)"http.max_length_of_post_body")) != null) {
            httpConfig.setMaxLengthOfPostBody(max_length_of_post_body * 1024);
        }
        int workerid = P.getInt((String)"uuid.workerid");
        int datacenter = P.getInt((String)"uuid.datacenter");
        sessionIdGenerator = new SnowflakeSessionIdGenerator(workerid, datacenter);
        httpConfig.setSessionIdGenerator((ISessionIdGenerator)sessionIdGenerator);
        httpConfig.setAppendRequestHeaderString(true);
        httpConfig.setPage500(P.get((String)"http.api.page500", (String)"/500.html"));
        httpConfig.setPage404(P.get((String)"http.api.page404", (String)"/404.html"));
        httpConfig.setSessionCookieName(Const.Http.SESSION_COOKIE_NAME);
        String pageRoot = P.get((String)"http.api.page", null);
        httpConfig.setPageRoot(pageRoot);
        CaffeineRedisCache caffeineRedisCache = CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)httpConfig.getSessionCacheName(), null, (Long)sessionTimeout);
        httpConfig.setSessionStore((ICache)caffeineRedisCache);
        httpConfig.setProxied(P.getBoolean((String)"http.isproxied", (Boolean)false).booleanValue());
        byte[] bs = Json.toJson((Object)Resp.fail((String)"Your IP is on the blacklist")).getBytes();
        httpConfig.setRespForBlackIp(new HttpResponse(null, bs));
        httpConfig.setSessionRateLimiter((SessionRateLimiter)WebApiSessionRateLimiter.me);
        String[] scanPackages = new String[]{WebApiRoot.class.getPackage().getName()};
        routes = new Routes(scanPackages);
        requestHandler = new DefaultHttpRequestHandler(httpConfig, routes);
        requestHandler.setCompatibilityAssignment(false);
        AccessCtrlConfig accessCtrlConfig = new AccessCtrlConfig("access-url-role.properties", WebApiInit.routes.PATH_METHOD_MAP.keySet(), false);
        WebApiHttpServerInterceptor.ME.setAccessCtrlConfig(accessCtrlConfig);
        requestHandler.setHttpServerInterceptor((HttpServerInterceptor)WebApiHttpServerInterceptor.ME);
        requestHandler.setHttpSessionListener((HttpSessionListener)WebApiHttpSessionListener.ME);
        String cookieDomain = P.get((String)"http.cookie.domain");
        DomainSessionCookieDecorator domainSessionCookieDecorator = new DomainSessionCookieDecorator(cookieDomain);
        requestHandler.setSessionCookieDecorator((SessionCookieDecorator)domainSessionCookieDecorator);
        requestHandler.setThrowableHandler((ThrowableHandler)TioSiteThrowableHandler.ME);
        httpConfig.setName("Web-Api");
        httpServerStarter = new HttpServerStarter(httpConfig, (HttpRequestHandler)requestHandler, Threads.getTioExecutor(), Threads.getGroupExecutor());
        httpServerStarter.getTioServer().setCheckLastVersion(P.getBoolean((String)"tio.setCheckLastVersion", (Boolean)false).booleanValue());
        serverTioConfig = httpServerStarter.getServerTioConfig();
        WebApiInit.serverTioConfig.logWhenDecodeError = P.getBoolean((String)"http.api.logWhenDecodeError", (Boolean)false);
        serverTioConfig.setName("Tio-Site Api HttpServer");
        serverTioConfig.setReadBufferSize(P.getInt((String)"http.api.readbuffersize", (Integer)20480).intValue());
        serverTioConfig.setIpStatListener((IpStatListener)TioSiteIpStatListener.web_api);
        WebApiInit.serverTioConfig.ipStats.addDurations(Const.IpStatDuration.IPSTAT_DURATIONS);
        boolean bl = isWebApiUseSsl = P.getInt((String)"web.api.use.ssl", (Integer)2) == 1;
        if (isWebApiUseSsl) {
            String keyStoreFile = P.get((String)"ssl.keystore", null);
            String trustStoreFile = P.get((String)"ssl.truststore", null);
            String keyStorePwd = P.get((String)"ssl.pwd", null);
            serverTioConfig.useSsl(keyStoreFile, trustStoreFile, keyStorePwd);
        }
        IpPathAccessStats ipPathAccessStats = new IpPathAccessStats((StatPathFilter)TioSiteStatPathFilter.me, (TioConfig)serverTioConfig, (IpPathAccessStatListener)TioSiteIpPathAccessStatListener.ME_SITE_API, Const.IpPathAccessStatDuration.IP_PATH_ACCESS_STAT_DURATIONS);
        requestHandler.setIpPathAccessStats(ipPathAccessStats);
        TokenPathAccessStats tokenPathAccessStats = new TokenPathAccessStats((StatPathFilter)TioSiteStatPathFilter.me, (TokenGetter)TioSiteTokenGetter.me, (CurrUseridGetter)TioSiteCurrUseridGetter.me, (TioConfig)serverTioConfig, (TokenPathAccessStatListener)TioSiteTokenPathAccessStatListener.ME_SITE_API, Const.TokenPathAccessStatDuration.TOKEN_PATH_ACCESS_STAT_DURATIONS);
        requestHandler.setTokenPathAccessStats(tokenPathAccessStats);
        HttpcacheInit.init(routes);
        httpServerStarter.start();
    }

    static {
        sessionIdGenerator = null;
    }
}

