/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.recharge.provider.alipay;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradePayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.utils.LogUtils;
import org.tio.mg.web.server.recharge.IRechargeProvider;
import org.tio.mg.web.server.recharge.RechargeUtils;
import org.tio.mg.web.server.recharge.provider.alipay.AlipayConfig;

public class AlipayRechargeProvider
implements IRechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final AlipayRechargeProvider me = new AlipayRechargeProvider();

    protected AlipayRechargeProvider() {
    }

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf(rechargeItem.getAmount());
        String body = "";
        AlipayTradePayModel model = new AlipayTradePayModel();
        model.setOutTradeNo(rechargeItem.getTradeno());
        model.setProductCode("FAST_INSTANT_TRADE_PAY");
        model.setTotalAmount(total_fee);
        model.setSubject(_subject);
        model.setBody(body);
        AlipayClient alipayClient = AlipayConfig.alipayClient;
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        alipayRequest.setReturnUrl(RechargeUtils.getReturnUrl(paytype, request));
        alipayRequest.setNotifyUrl(RechargeUtils.getNotifyUrl(paytype, request));
        alipayRequest.setBizModel((AlipayObject)model);
        String form = "";
        try {
            form = ((AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u751f\u6210\u652f\u4ed8\u9875\u9762\u65f6\u4ea7\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return Resps.html((HttpRequest)request, (String)form);
    }

    private static Map<String, String> toMap(HttpRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParams();
        Set set = requestParams.entrySet();
        for (Map.Entry entry : set) {
            String name = (String)entry.getKey();
            if ("paytype".equals(name)) continue;
            Object[] values = (Object[])entry.getValue();
            String valueStr = ArrayUtil.join((Object[])values, (CharSequence)",");
            params.put(name, valueStr == null ? "" : valueStr);
        }
        return params;
    }

    @Override
    public boolean isValidCallback(HttpRequest request, int callbackType) throws Exception {
        Map<String, String> params = AlipayRechargeProvider.toMap(request);
        boolean verify_result = AlipaySignature.rsaCheckV1(params, (String)AlipayConfig.publicKey, (String)"utf-8", (String)"RSA2");
        return verify_result;
    }

    @Override
    public String getTradeno(HttpRequest request, int callbackType) {
        String out_trade_no = request.getParam("out_trade_no");
        return out_trade_no;
    }

    @Override
    public void fillOnNotify(HttpRequest request, RechargeItem rechargeItem, int callbackType) {
        String trade_no = request.getParam("trade_no");
        String trade_status = request.getParam("trade_status");
        String buyer_id = request.getParam("buyer_id");
        String total_amount = request.getParam("total_amount");
        Double thirdamount = Double.parseDouble(total_amount);
        String gmt_payment = request.getParam("gmt_payment");
        String notify_id = request.getParam("notify_id");
        rechargeItem.setThirdtradeno(trade_no);
        rechargeItem.setThirdstatus(trade_status);
        rechargeItem.setThirdaccount(buyer_id);
        rechargeItem.setThirdamount(thirdamount);
        rechargeItem.setThirdnotifyid(notify_id);
        try {
            rechargeItem.setThirdtradetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(gmt_payment));
        }
        catch (Exception e) {
            LogUtils.getCoinLog().error(gmt_payment + "\u8fdb\u884c\u65e5\u671f\u8f6c\u6362\u51fa\u9519\u4e86", (Throwable)e);
        }
        if ("TRADE_SUCCESS".equals(trade_status)) {
            rechargeItem.setStatus(Integer.valueOf(2));
        } else if ("TRADE_FINISHED".equals(trade_status)) {
            rechargeItem.setStatus(Integer.valueOf(4));
        } else if ("TRADE_CLOSED".equals(trade_status)) {
            rechargeItem.setStatus(Integer.valueOf(3));
        } else {
            rechargeItem.setStatus(Integer.valueOf(99));
        }
        rechargeItem.setRemark(StringUtils.left((String)(request.getHeaderString() + request.getBodyString()), (int)2048));
    }

    @Override
    public HttpResponse notifySuccess(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        return Resps.html((HttpRequest)request, (String)"success");
    }

    @Override
    public HttpResponse notifyFail(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        return Resps.html((HttpRequest)request, (String)"fail");
    }
}

