/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.recharge.provider.weixin;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.util.Resps;
import org.tio.jfinal.kit.HashKit;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.service.recharge.RechargeItemService;
import org.tio.mg.service.utils.LogUtils;
import org.tio.mg.web.server.recharge.RechargeUtils;
import org.tio.mg.web.server.recharge.provider.weixin.TradeType;
import org.tio.mg.web.server.recharge.provider.weixin.WxPayScan2RechargeProvider;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

public class WxPayAppRechargeProvider
extends WxPayScan2RechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final WxPayAppRechargeProvider me = new WxPayAppRechargeProvider();

    protected WxPayAppRechargeProvider() {
    }

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf((int)NumberUtil.mul((double)rechargeItem.getAmount(), (float)100.0f));
        String tradeno = rechargeItem.getTradeno();
        String ip = request.getClientIp();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("body", _subject);
        data.put("out_trade_no", tradeno);
        data.put("device_info", "");
        data.put("fee_type", "CNY");
        data.put("total_fee", total_fee);
        data.put("spbill_create_ip", ip);
        data.put("notify_url", RechargeUtils.getNotifyUrl(paytype, request));
        data.put("trade_type", TradeType.APP.getValue());
        data.put("product_id", tradeno);
        try {
            Map r = this.wxpay.unifiedOrder(data);
            String returnCode = (String)r.get("return_code");
            if ("SUCCESS".equals(returnCode)) {
                String result_code = (String)r.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String prepay_id = (String)r.get("prepay_id");
                    if (StrUtil.isNotBlank((CharSequence)prepay_id)) {
                        rechargeItem.setThirdtradeno(prepay_id);
                        RechargeItemService.me.update(rechargeItem);
                        HashMap<String, String> packageParams = new HashMap<String, String>();
                        packageParams.put("appid", this.config.getAppID());
                        packageParams.put("partnerid", this.config.getMchID());
                        packageParams.put("prepayid", prepay_id);
                        packageParams.put("package", "Sign=WXPay");
                        packageParams.put("noncestr", System.currentTimeMillis() + "");
                        packageParams.put("timestamp", System.currentTimeMillis() / 1000L + "");
                        String packageSign = WxPayAppRechargeProvider.createSign(packageParams, this.config.getKey());
                        packageParams.put("sign", packageSign);
                        HashMap<String, HashMap<String, String>> ret = new HashMap<String, HashMap<String, String>>();
                        ret.put("wechat", packageParams);
                        return Resps.json((HttpRequest)request, (Object)Resp.ok(ret));
                    }
                } else {
                    log.error("\u5fae\u4fe1APP\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
                }
            } else {
                log.error("\u5fae\u4fe1APP\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return Resps.json((HttpRequest)request, (Object)Resp.fail((String)"\u672a\u77e5\u5f02\u5e38"));
    }

    public static String createSign(Map<String, String> params, String partnerKey) {
        params.remove("sign");
        String stringA = WxPayAppRechargeProvider.packageSign(params, false);
        String stringSignTemp = stringA + "&key=" + partnerKey;
        return HashKit.md5((String)stringSignTemp).toUpperCase();
    }

    public static String packageSign(Map<String, String> params, boolean urlEncoder) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> param : sortedParams.entrySet()) {
            String value = param.getValue();
            if (StrUtil.isBlank((CharSequence)value)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(param.getKey()).append("=");
            if (urlEncoder) {
                try {
                    value = WxPayAppRechargeProvider.urlEncode(value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, "utf-8").replace("+", "%20");
    }
}

