/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.model.mg.MgInvoice;
import org.tio.mg.web.server.init.WebApiInit;
import org.tio.sitexxx.service.vo.Const;

public class UploadUtils {
    private static Logger log = LoggerFactory.getLogger(UploadUtils.class);

    public static String dataRootPath(String subDir, int uid) {
        long uid1 = (long)uid + 74541287548L;
        long base = 107L;
        long dir1 = uid1 % base;
        long dir2 = uid1 % (base * base);
        long dir3 = uid1 % (base * base * base);
        long dir4 = uid1 % (base * base * base * base);
        String path = "/" + subDir + "/" + dir1 + "/" + dir2 + "/" + dir3 + "/" + dir4 + "/" + uid1;
        return path;
    }

    public static String newFile(String subDir, int uid, String filename) {
        String path = UploadUtils.dataRootPath(subDir, uid);
        Date date = new Date();
        path = path + "/" + RandomUtil.randomInt((int)1, (int)120);
        String resRootDir = Const.RES_ROOT;
        File dir = new File(resRootDir, path);
        FileUtil.mkdir((File)dir);
        String fileName = DateUtil.format((Date)date, (String)"HHmmss");
        if (filename != null) {
            fileName = fileName + "/" + WebApiInit.sessionIdGenerator.nextId();
        }
        return path + "/" + fileName;
    }

    public static String mgSubDir(Byte type) {
        switch (type) {
            case 1: {
                return "recruit/cmp/logo";
            }
            case 2: {
                return "order/contract";
            }
            case 3: {
                return "app/file";
            }
        }
        return "mg/default";
    }

    public static String dateFile(String subDir) {
        String path = "/" + subDir + "/";
        Date date = new Date();
        path = path + DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        path = path + RandomUtil.randomInt((int)1, (int)120);
        String resRootDir = Const.RES_ROOT;
        File dir = new File(resRootDir, path);
        FileUtil.mkdir((File)dir);
        return path + "/" + DateUtil.format((Date)date, (String)"HHmmss") + WebApiInit.sessionIdGenerator.nextId();
    }

    public static String invoice(String subDir, String nick, MgInvoice invoice) {
        double amonut;
        String path = subDir;
        if (StrUtil.isBlank((CharSequence)nick)) {
            nick = "\u7f3a\u7701\u540d\u79f0";
        }
        if ((amonut = invoice.getAmount().doubleValue()) <= 0.0) {
            amonut = 0.0;
        }
        path = path + "/" + nick + "/";
        String resRootDir = Const.RES_ROOT;
        File dir = new File(resRootDir, path);
        FileUtil.mkdir((File)dir);
        String fileName = nick;
        fileName = fileName + "-" + DateUtil.format((Date)new Date(), (String)"yyMMddHHmmssSSS");
        fileName = fileName + "-" + invoice.getName() + "\uffe5" + amonut;
        Pattern pattern = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher matcher = pattern.matcher(fileName);
        fileName = matcher.replaceAll("");
        return path + "/" + fileName;
    }

    public static void main(String[] args) {
    }
}

