/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.http.common.HttpRequest;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.server.handler.ImServerHandler;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.UserActionLog;
import org.tio.sitexxx.service.model.main.UserAgent;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.UserAgentService;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.UserActionLogReq)
public class UserActionLogReqHandler
implements ImServerHandler {
    private static Logger log = LoggerFactory.getLogger(UserActionLogReqHandler.class);

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket) throws Exception {
        User curr = ImUtils.getUser((ChannelContext)channelContext);
        UserActionLog userActionLog = (UserActionLog)Json.toBean((String)packet.getBodyStr(), UserActionLog.class);
        userActionLog.setActiondesc(UserActionLog.Action.getName((int)userActionLog.getActiontype()));
        userActionLog.setInitpath(userActionLog.getPath());
        userActionLog.setSession(ImUtils.getToken((ChannelContext)channelContext));
        if (curr != null) {
            userActionLog.setMayuid(curr.getId());
            userActionLog.setUid(curr.getId());
        } else {
            SimpleUser fromUser = ImUtils.getHandshakeSimpleUser((ChannelContext)channelContext);
            if (fromUser != null) {
                if (fromUser.getMay() != null) {
                    userActionLog.setMayuid(fromUser.getMay().getI());
                } else {
                    userActionLog.setMayuid(fromUser.getI());
                }
                userActionLog.setUid(fromUser.getI());
            }
        }
        if (isWebsocket) {
            HttpRequest httpRequest = ImUtils.getHandshakeRequest((ChannelContext)channelContext);
            String ua = httpRequest.getUserAgent();
            UserAgent userAgent = UserAgentService.ME.save(ua);
            userActionLog.setUaid(userAgent.getId());
        }
        userActionLog.save();
    }
}

