/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.friend;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.jfinal.kit.Ret;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.friend.WxFriendMsgReq;
import org.tio.sitexxx.im.common.bs.wx.friend.WxFriendMsgResp;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.ChatMsgService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxFriendMsgReq)
public class WxFriendMsgReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxFriendMsgReqHandler.class);
    public static final WxFriendMsgReqHandler me = new WxFriendMsgReqHandler();

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        WxFriendMsgReq msgReq = (WxFriendMsgReq)Json.toBean((String)packet.getBodyStr(), WxFriendMsgReq.class);
        Long chatlinkid = msgReq.getChatlinkid();
        Long startmid = msgReq.getStartmid();
        Long endmid = msgReq.getEndmid();
        Ret ret = ChatMsgService.me.p2pMsgList(chatlinkid, curr.getId(), startmid, endmid);
        if (ret.isFail()) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20001, RetUtils.getRetMsg((Ret)ret));
            return;
        }
        List data = (List)RetUtils.getOkTData((Ret)ret);
        WxFriendMsgResp wxFriendMsgResp = new WxFriendMsgResp();
        wxFriendMsgResp.setData(data);
        wxFriendMsgResp.setChatlinkid(chatlinkid);
        if (data.size() < ConfService.getInt((String)"im.history.chat.count.p2p", (Integer)FriendService.WX_FRIEND_MSG_LIMIT)) {
            wxFriendMsgResp.setLastPage(true);
        }
        ImPacket imPacket = new ImPacket(Command.WxFriendMsgResp, (Object)wxFriendMsgResp);
        Ims.send(channelContext, imPacket);
    }
}

