/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.handler.wx.group;

import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.bs.wx.group.WxGroupChatNtf;
import org.tio.sitexxx.im.common.bs.wx.group.WxGroupChatReq;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.im.server.handler.AbsImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.WxChatApi;
import org.tio.sitexxx.im.server.handler.wx.WxChatQueueApi;
import org.tio.sitexxx.im.server.utils.ImUtils;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.main.WxGroupUser;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.chat.SynService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.sitexxx.service.service.wx.WxGroupService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.SimpleUser;
import org.tio.sitexxx.service.vo.wx.WxMsgCardVo;
import org.tio.utils.SystemTimer;
import org.tio.utils.json.Json;

@CommandHandler(value=Command.WxGroupChatReq)
public class WxGroupChatReqHandler
extends AbsImServerHandler {
    private static Logger log = LoggerFactory.getLogger(WxGroupChatReqHandler.class);
    public static final WxGroupChatReqHandler me = new WxGroupChatReqHandler();
    private static UserService userService = UserService.ME;

    @Override
    public void handler(ImPacket packet, ChannelContext channelContext, boolean isWebsocket, User curr, SimpleUser currSimpleUser) throws Exception {
        String ip;
        boolean isSuper = UserService.isSuper((User)curr);
        WxGroupChatReq wxGroupChatReq = (WxGroupChatReq)Json.toBean((String)packet.getBodyStr(), WxGroupChatReq.class);
        Long chatlinkid = wxGroupChatReq.getChatlinkid();
        if (Objects.equals(curr.getMsgforbiddenflag(), (byte)1)) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), chatlinkid, (Integer)20005, "\u4f60\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u8a00");
            return;
        }
        String c = StrUtil.trim((CharSequence)wxGroupChatReq.getC());
        if (wxGroupChatReq.getCardid() == null && StrUtil.isBlank((CharSequence)c)) {
            return;
        }
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        Long groupid = wxGroupChatReq.getG();
        if (StrUtil.isNotBlank((CharSequence)c) && c.length() > 2048) {
            ImUtils.info(channelContext, "\u4f60\u53d1\u7684\u5185\u5bb9\u6709\u70b9\u957f^_^", null);
            return;
        }
        if (!isSuper && !IpWhiteListService.isWhiteIp((String)(ip = channelContext.getClientNode().getIp()))) {
            int interval;
            long currtime = SystemTimer.currTime;
            ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
            long lastGroupChatTime = imSessionContext.getLastGroupChatTime();
            if (currtime - lastGroupChatTime <= (long)(interval = ConfService.getInt((String)"im.group.chat.time.interval", (Integer)2000).intValue())) {
                ImUtils.info(channelContext, "\u53d1\u8a00\u8fc7\u5feb", null);
                return;
            }
            imSessionContext.setLastGroupChatTime(currtime);
        }
        if (chatlinkid == null) {
            log.error("\u4f1a\u8bddid\u4e3a\u7a7a");
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), null, (Integer)20001, "\u4f1a\u8bdd\u4e3a\u7a7a");
            return;
        }
        groupid = Math.abs(chatlinkid);
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex((String)curr.getId(), (Long)groupid);
        Ret check = WxChatApi.checkGroupChat(groupItem);
        if (check.isFail()) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), RetUtils.getIntCode((Ret)check), RetUtils.getRetMsg((Ret)check));
            return;
        }
        WxGroupUser groupUser = GroupService.me.getGroupUser(groupItem.getGpulinkid());
        if (groupUser == null) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), (Integer)30001, "\u7fa4\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        if (Objects.equals(groupUser.getMsgforbiddenflag(), (byte)1)) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), (Integer)30005, "\u4f60\u5df2\u88ab\u7fa4\u7ba1\u7406\u5458\u7981\u8a00");
            return;
        }
        Byte contenttype = 1;
        if (wxGroupChatReq.getCardid() != null) {
            Ret ret = null;
            if (Objects.equals(wxGroupChatReq.getCardtype(), (byte)1)) {
                ret = FriendService.me.getFdCard(curr.getId(), String.valueOf(wxGroupChatReq.getCardid()));
            } else if (Objects.equals(wxGroupChatReq.getCardtype(), (byte)2)) {
                ret = GroupService.me.getGroupCard(curr.getId(), wxGroupChatReq.getCardid());
            } else {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), (Integer)30001, "\u65e0\u6548\u540d\u7247\u7c7b\u578b");
                return;
            }
            if (ret.isFail()) {
                WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), (Integer)30001, RetUtils.getRetMsg((Ret)ret));
                return;
            }
            WxMsgCardVo cardVo = (WxMsgCardVo)RetUtils.getOkTData((Ret)ret);
            cardVo.setShareToBizid(String.valueOf(groupItem.getGroupid()));
            c = Json.toJson((Object)cardVo);
            contenttype = 9;
        }
        chatlinkid = groupItem.getChatlinkid();
        Ret ret = WxChatApi.sendGroupMsgEach(channelContext, c, contenttype, curr.getId(), groupid, chatlinkid, null, null, wxGroupChatReq.getAt());
        if (ret.isFail()) {
            WxChatApi.sendFriendErrorMsg(channelContext, curr.getId(), curr.getId(), curr.getId(), (Long)(-groupid.longValue()), (Integer)30001, RetUtils.getRetMsg((Ret)ret));
            return;
        }
        Map focusMap = SynService.me.focusDevice(curr.getId(), devicetype.getValue());
        if (focusMap == null || focusMap.get(chatlinkid + "") == null) {
            IpInfo ipInfo = IpInfoService.ME.save(channelContext.getClientNode().getIp());
            WxChatQueueApi.joinFocusQueue(channelContext, curr, groupItem.getChatlinkid(), groupid, (byte)2, devicetype.getValue(), ipInfo.getId());
        }
    }

    public static void groupChatAndLog(ChannelContext channelContext, String text, String fromUid, Integer[] at, Long groupid, Byte contenttype, byte sendbysys) {
        Devicetype devicetype = ImUtils.getDevicetype((ChannelContext)channelContext);
        String sessionid = ImUtils.getToken((ChannelContext)channelContext);
        String fromIp = channelContext.getClientNode().getIp();
        WxGroupChatReqHandler.groupChatAndLog(devicetype, sessionid, text, fromUid, at, fromIp, groupid, contenttype, sendbysys);
    }

    public static boolean groupChatAndLog(Devicetype devicetype, String sessionid, String text, String fromUid, Integer[] at, String fromIp, long groupid, Byte contenttype, byte sendbysys) {
        Record record = WxGroupService.me.info(Long.valueOf(groupid));
        if (record == null) {
            return false;
        }
        WxGroupMsg wxGroupMsg = WxGroupService.me.saveChatRecord(devicetype, sessionid, text, fromUid, fromIp, groupid, contenttype, sendbysys);
        WxGroupChatNtf wxGroupChatNtf = new WxGroupChatNtf();
        wxGroupChatNtf.setC(text);
        wxGroupChatNtf.setF(fromUid);
        wxGroupChatNtf.setG(Long.valueOf(groupid));
        wxGroupChatNtf.setD(devicetype.getValue());
        wxGroupChatNtf.setCt(contenttype);
        wxGroupChatNtf.setMid(wxGroupMsg.getId());
        if (Objects.equals(sendbysys, (byte)1)) {
            wxGroupChatNtf.setSendbysys(Byte.valueOf(sendbysys));
        }
        ImPacket imPacket = new ImPacket(Command.WxGroupChatNtf, (Object)wxGroupChatNtf);
        Ims.sendToGroup(groupid, imPacket);
        return true;
    }
}

