/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.stat.ChannelStat;
import org.tio.http.common.HttpRequest;
import org.tio.monitor.RateLimiterWrap;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandHandler;
import org.tio.sitexxx.im.common.CommandStat;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.handler.ImServerHandler;
import org.tio.sitexxx.service.model.stat.TioIpPullblackLog;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.TioIpPullblackLogService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassScanHandler;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;

public class PacketDispatcher {
    private static Logger log = LoggerFactory.getLogger(PacketDispatcher.class);
    public Map<Command, ImServerHandler> handlerMap = new TreeMap<Command, ImServerHandler>();
    public Map<Command, Class<?>> pathClassMap = new TreeMap();

    public void dispatch(ImPacket imPacket, ChannelContext channelContext, boolean isWebsocket) throws Exception {
        ImServerHandler handler;
        Command command = imPacket.getCommand();
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        log.debug("{}, \u6536\u5230\u547d\u4ee4:{}", (Object)channelContext, (Object)command);
        if (!imSessionContext.isHandshaked() && command != Command.WxHandshakeReq) {
            log.warn("{} \u7b2c\u4e00\u4e2a\u4e1a\u52a1\u5305\u5fc5\u987b\u4e3a\u63e1\u624b\u5305\uff0c\u672c\u6b21\u547d\u4ee4:{}", (Object)channelContext.toString(), (Object)command);
            Tio.remove((ChannelContext)channelContext, (String)"\u7b2c\u4e00\u4e2a\u4e1a\u52a1\u5305\u5fc5\u987b\u4e3a\u63e1\u624b\u5305");
            return;
        }
        ChannelStat channelStat = channelContext.stat;
        if (channelStat.receivedPackets.get() > (long)P.getInt((String)"skip.warn.count").intValue()) {
            RateLimiterWrap rateLimiterWrap = null;
            rateLimiterWrap = imSessionContext.getRequestRateLimiter();
            boolean[] limitTest = rateLimiterWrap.tryAcquire();
            if (!limitTest[0] && !limitTest[1]) {
                String remark = channelContext.toString() + " \u8bbf\u95ee\u592a\u9891\u7e41\uff0c \u5c06\u62c9\u9ed1\u5176IP\uff0c\u672c\u6b21\u547d\u4ee4:" + command;
                log.warn(remark);
                Node clientNode = channelContext.getClientNode();
                HttpRequest request = ImUtils.getHandshakeRequest((ChannelContext)channelContext);
                User user = ImUtils.getUser((ChannelContext)channelContext);
                String currId = user == null ? null : user.getId();
                String ip = clientNode.getIp();
                TioIpPullblackLog tioIpPullblackLog = new TioIpPullblackLog();
                tioIpPullblackLog.setIp(ip);
                tioIpPullblackLog.setIpid(IpInfoService.ME.save(ip).getId());
                tioIpPullblackLog.setRemark(remark);
                tioIpPullblackLog.setServer(Const.MY_IP);
                tioIpPullblackLog.setServerport(Integer.valueOf(request.getChannelContext().getServerNode().getPort()));
                tioIpPullblackLog.setTime(new Date());
                tioIpPullblackLog.setType(Byte.valueOf((byte)4));
                tioIpPullblackLog.setSessionid(ImUtils.getToken((ChannelContext)channelContext));
                tioIpPullblackLog.setCookie(request.getHeader("cookie"));
                tioIpPullblackLog.setInitpath(request.requestLine.getInitPath());
                tioIpPullblackLog.setPath(command.name());
                tioIpPullblackLog.setRequestline(request.requestLine.toString());
                tioIpPullblackLog.setUid(currId);
                TioIpPullblackLogService.ME.addToBlack(tioIpPullblackLog);
                return;
            }
            if (!limitTest[0] && limitTest[1]) {
                log.warn("{} \u8bbf\u95ee\u592a\u9891\u7e41\uff0c\u5c06\u8b66\u544a\u4e00\u6b21\uff0c\u672c\u6b21\u547d\u4ee4:{}", (Object)channelContext.toString(), (Object)command);
                return;
            }
        }
        if ((handler = this.handlerMap.get(command)) != null) {
            log.debug("{} \u6536\u5230\u6d88\u606f:{}, isWebsocket:{}", new Object[]{channelContext, command, isWebsocket});
            handler.handler(imPacket, channelContext, isWebsocket);
            CommandStat.getCommandStat((Command)command).handled.incrementAndGet();
            return;
        }
        log.warn("\u547d\u4ee4\u7801[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u5904\u7406\u7c7b", (Object)command);
        CommandStat.getCommandStat((Command)command).handled.incrementAndGet();
    }

    public PacketDispatcher(String[] scanPackages) {
        if (scanPackages != null) {
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(CommandHandler.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            try {
                                Object bean = clazz.newInstance();
                                if (!(bean instanceof ImServerHandler)) {
                                    log.error("{}\u6ca1\u6709\u5b9e\u73b0 {}", (Object)clazz.getName(), (Object)ImServerHandler.class.getName());
                                    return;
                                }
                                ImServerHandler imServerHandler = (ImServerHandler)bean;
                                CommandHandler mapping = clazz.getAnnotation(CommandHandler.class);
                                Command command = mapping.value();
                                ImServerHandler obj = PacketDispatcher.this.handlerMap.get(command);
                                if (obj != null) {
                                    log.error("mapping[{}] already exists in class [{}]", (Object)command, (Object)obj.getClass().getName());
                                } else {
                                    PacketDispatcher.this.handlerMap.put(command, imServerHandler);
                                    PacketDispatcher.this.pathClassMap.put(command, clazz);
                                }
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            log.warn("command mapping\r\n{}", (Object)Json.toFormatedJson(this.pathClassMap));
        }
    }

    public static void main(String[] args) {
    }
}

