/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.lionsoul.ip2region.DataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.monitor.RateLimiterWrap;
import org.tio.server.intf.ServerAioListener;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.CommandStat;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImSessionContext;
import org.tio.sitexxx.im.common.utils.ImUtils;
import org.tio.sitexxx.im.server.handler.wx.WxChatQueueApi;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.ip2region.Ip2Region;
import org.tio.sitexxx.service.model.main.ChatroomJoinLeave;
import org.tio.sitexxx.service.model.main.WxCallItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.chat.SynService;
import org.tio.sitexxx.service.service.wx.WxCallItemService;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.utils.cache.ICache;
import org.tio.utils.jfinal.P;

public class TioSiteImServerAioListener
implements ServerAioListener {
    private static Logger log = LoggerFactory.getLogger(TioSiteImServerAioListener.class);
    static AtomicLong accessCount = new AtomicLong();
    public static final TioSiteImServerAioListener me = new TioSiteImServerAioListener();

    private TioSiteImServerAioListener() {
    }

    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect) {
        ImSessionContext imSessionContext = new ImSessionContext();
        channelContext.setAttribute("im_session_key", (Object)imSessionContext);
        int permitsPerSecond = P.getInt((String)"request.permitsPerSecond");
        int warnClearInterval = 1000 * P.getInt((String)"request.warnClearInterval");
        int maxWarnCount = P.getInt((String)"request.maxWarnCount");
        int maxAllWarnCount = P.getInt((String)"request.maxAllWarnCount");
        RateLimiterWrap rateLimiterWrap = new RateLimiterWrap(permitsPerSecond, warnClearInterval, maxWarnCount, maxAllWarnCount);
        imSessionContext.setRequestRateLimiter(rateLimiterWrap);
        if (isConnected) {
            String ip = channelContext.getClientNode().getIp();
            DataBlock dataBlock = Ip2Region.getDataBlock((String)ip);
            imSessionContext.setDataBlock(dataBlock);
        }
    }

    public void onAfterDecoded(ChannelContext channelContext, Packet packet, int packetSize) {
        if (packet instanceof ImPacket) {
            ImPacket imPacket = (ImPacket)packet;
            CommandStat.getCommandStat((Command)imPacket.getCommand()).received.incrementAndGet();
        }
    }

    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess) {
        if (packet instanceof ImPacket) {
            ImPacket imPacket = (ImPacket)packet;
            if (isSentSuccess) {
                CommandStat.getCommandStat((Command)imPacket.getCommand()).sent.incrementAndGet();
            }
        }
    }

    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) {
        ChatroomJoinLeave chatroomJoinLeave;
        User curr = ImUtils.getUser((ChannelContext)channelContext);
        ImSessionContext imSessionContext = ImUtils.getImSessionContext((ChannelContext)channelContext);
        if (curr != null) {
            Devicetype devicetype;
            String cid;
            WxCallItem wxCallItem;
            Long callId = imSessionContext.getCallId();
            if (callId == null) {
                ICache cache = Caches.getCache((CacheConfig)CacheConfig.WX_IS_CALLING);
                callId = (Long)cache.get(curr.getId() + "", Long.class);
            }
            if (callId != null && (wxCallItem = WxCallItemService.me.getById(callId)) != null && ((cid = channelContext.getId()).equals(wxCallItem.getFromcid()) || cid.equals(wxCallItem.getTocid()) || Objects.equals(wxCallItem.getStatus(), (byte)1))) {
                WxCallUtils.endCall(channelContext, callId, curr.getId(), (byte)4);
            }
            if (Objects.equals((devicetype = ImUtils.getDevicetype((ChannelContext)channelContext)).getValue(), Devicetype.IOS.getValue()) || Objects.equals(devicetype.getValue(), Devicetype.ANDROID.getValue())) {
                devicetype = Devicetype.APP;
            }
            WxChatQueueApi.leaveFocusQueue(curr, devicetype.getValue(), channelContext.getId());
            if (Objects.equals(devicetype.getValue(), Devicetype.APP.getValue()) || Objects.equals(devicetype.getValue(), Devicetype.H5.getValue())) {
                SynService.me.insertSynTime(devicetype.getValue(), curr.getId(), Byte.valueOf((byte)1), new Date(), false);
            }
        }
        if (imSessionContext != null && (chatroomJoinLeave = imSessionContext.getChatroomJoinLeave()) != null && chatroomJoinLeave.isChat()) {
            long cost = System.currentTimeMillis() - chatroomJoinLeave.getJointime().getTime();
            String sql = "update chatroom_join_leave set leavetime = ?, cost = ?, status = 1 where id = ?";
            Db.use((String)"tio_site_main").update(sql, new Object[]{new Date(), cost, chatroomJoinLeave.getId()});
        }
    }

    public void onAfterHandled(ChannelContext channelContext, Packet packet, long cost) throws Exception {
    }

    public void onAfterReceivedBytes(ChannelContext channelContext, int receivedBytes) throws Exception {
    }

    public boolean onHeartbeatTimeout(ChannelContext channelContext, Long interval, int heartbeatTimeoutCount) {
        return false;
    }
}

