/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server;

import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.client.CluClientStarter;
import org.tio.clu.client.bs.TransferListener;
import org.tio.clu.client.handler.rpc.demo.RpcDemoImpl;
import org.tio.clu.common.bs.rpc.RpcApi;
import org.tio.core.Node;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.TioUuid;
import org.tio.core.stat.IpStatListener;
import org.tio.flash.policy.server.FlashPolicyServerStarter;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.server.ServerTioConfig;
import org.tio.server.TioServer;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.ImTioUuid;
import org.tio.sitexxx.im.server.ChannelContextComparator;
import org.tio.sitexxx.im.server.ImToWsPacketConverter;
import org.tio.sitexxx.im.server.PacketDispatcher;
import org.tio.sitexxx.im.server.TioSiteImGroupListener;
import org.tio.sitexxx.im.server.TioSiteImServerAioHandler;
import org.tio.sitexxx.im.server.TioSiteImServerAioListener;
import org.tio.sitexxx.im.server.clu.ImTransferListener;
import org.tio.sitexxx.im.server.handler.ImServerHandler;
import org.tio.sitexxx.im.server.handler.wx.call.WxCallUtils;
import org.tio.sitexxx.im.server.init.TopicInit;
import org.tio.sitexxx.im.server.ws.ImWsStarter;
import org.tio.sitexxx.service.init.CacheInit;
import org.tio.sitexxx.service.init.JFInit;
import org.tio.sitexxx.service.init.JsonInit;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.ip2region.Ip2RegionInit;
import org.tio.sitexxx.service.service.base.SensitiveWordsService;
import org.tio.sitexxx.service.tio.TioSiteIpStatListener;
import org.tio.sitexxx.service.utils.LogUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.Threads;
import org.tio.utils.jfinal.P;
import org.tio.utils.quartz.QuartzUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class TioSiteImServerStarter {
    private static Logger log = LoggerFactory.getLogger(TioSiteImServerStarter.class);
    public static ImTioUuid imTioUuid;
    public static PacketDispatcher packetDispatcher;
    public static ServerAioHandler tioSiteImServerAioHandler;
    public static ServerAioListener tioSiteImServerAioListener;
    public static TioSiteImGroupListener tioSiteImGroupListener;
    public static String bindIp;
    public static ServerTioConfig serverTioConfigApp;
    public static TioServer tioServerApp;
    public static ServerTioConfig serverTioConfigWs;
    public static ImWsStarter imWsStarter;
    public static CluClientStarter cluClientStarter;

    public static void main(String[] args) throws Exception {
        try {
            PropInit.init();
            Ip2RegionInit.init();
            SensitiveWordsService.init();
            JsonInit.init();
            JFInit.init();
            CacheInit.init((boolean)true);
            RedisInit.init((boolean)true);
            TopicInit.init();
            TioSiteImServerStarter.initImServer();
            FlashPolicyServerStarter.start(null, null, (SynThreadPoolExecutor)Threads.getTioExecutor(), (ThreadPoolExecutor)Threads.getGroupExecutor());
            QuartzUtils.start();
        }
        catch (Throwable e) {
            log.error("", e);
            System.exit(1);
        }
    }

    public static void initImServer() throws Exception {
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String sql1 = "update chatroom_join_leave set leavetime=DATE_ADD(jointime, INTERVAL 5 second), cost=5000, status = 2 where status = 9 and server = ?";
                String sql2 = "update chatroom_join_leave set status = 2 where status = 3 and server = ?";
                Db.use((String)"tio_site_main").update(sql1, new Object[]{Const.MY_IP});
                Db.use((String)"tio_site_main").update(sql2, new Object[]{Const.MY_IP});
                WxCallUtils.endAllCall();
            }
        });
        packetDispatcher = new PacketDispatcher(new String[]{ImServerHandler.class.getPackage().getName()});
        tioSiteImServerAioHandler = new TioSiteImServerAioHandler(packetDispatcher);
        tioSiteImServerAioListener = TioSiteImServerAioListener.me;
        tioSiteImGroupListener = TioSiteImGroupListener.me;
        serverTioConfigApp = new ServerTioConfig("Tio Site App Im Server", tioSiteImServerAioHandler, tioSiteImServerAioListener, Threads.getTioExecutor(), Threads.getGroupExecutor());
        serverTioConfigApp.setHeartbeatTimeout(Const.IM_HEARTBEAT_TIMEOUT);
        serverTioConfigApp.setReadBufferSize(P.getInt((String)"im.socket.readbuffersize", (Integer)1024).intValue());
        TioSiteImServerStarter.serverTioConfigApp.logWhenDecodeError = P.getBoolean((String)"im.logWhenDecodeError", (Boolean)false);
        TioSiteImServerStarter.serverTioConfigApp.groups.setChannelContextComparator((Comparator)ChannelContextComparator.me);
        long workerId = P.getLong((String)"uuid.workerid");
        long datacenterId = P.getLong((String)"uuid.datacenter");
        imTioUuid = new ImTioUuid(workerId, datacenterId);
        LogUtils.logJvmStartTime((String)(TioSiteImServerStarter.class.getName() + "\uff1aimTioUuid = new ImTioUuid(workerId, datacenterId)"));
        serverTioConfigApp.setTioUuid((TioUuid)imTioUuid);
        serverTioConfigApp.setGroupListener((GroupListener)tioSiteImGroupListener);
        serverTioConfigApp.setIpStatListener((IpStatListener)TioSiteIpStatListener.app);
        TioSiteImServerStarter.serverTioConfigApp.ipStats.addDurations(Const.IpStatDuration.IPSTAT_DURATIONS);
        TioSiteImServerStarter.useSsl(serverTioConfigApp);
        tioServerApp = new TioServer(serverTioConfigApp);
        tioServerApp.setCheckLastVersion(P.getBoolean((String)"tio.setCheckLastVersion", (Boolean)false).booleanValue());
        if (Const.USE_TIO_CLU) {
            Node cluServerNode = new Node(P.get((String)"tio.clu.server.ip"), P.getInt((String)"tio.clu.server.port").intValue());
            cluClientStarter = new CluClientStarter(false, serverTioConfigApp, cluServerNode, ImPacket.class);
            HashMap<String, Node> clientAccessNodeMap = new HashMap<String, Node>(2);
            Node node_app = new Node(Const.MY_IP, Const.ImPort.APP.intValue(), Const.IM_SSL_FLAG);
            Node node_ws = new Node(Const.MY_IP, Const.ImPort.WS.intValue(), Const.IM_SSL_FLAG);
            clientAccessNodeMap.put("app", node_app);
            clientAccessNodeMap.put("ws", node_ws);
            serverTioConfigApp.setClientAccessNodeMap(clientAccessNodeMap);
            cluClientStarter.start();
            serverTioConfigApp.setCluClientChannelContexts(cluClientStarter.getClientChannelContexts());
            serverTioConfigApp.setCluClientTioConfig(cluClientStarter.getClientTioConfig());
            serverTioConfigApp.setTransferListener((TransferListener)ImTransferListener.me);
        }
        LogUtils.logJvmStartTime((String)(TioSiteImServerStarter.class.getName() + "\uff1acluClientStarter.getClientTioConfig()"));
        tioServerApp.start(bindIp, Const.ImPort.APP.intValue());
        LogUtils.logJvmStartTime((String)(TioSiteImServerStarter.class.getName() + "\uff1atioServerApp.start(bindIp, Const.ImPort.APP)"));
        imWsStarter = new ImWsStarter(Const.ImPort.WS, (TioUuid)imTioUuid, packetDispatcher);
        imWsStarter.getWsServerStarter().getTioServer().setCheckLastVersion(P.getBoolean((String)"tio.setCheckLastVersion", (Boolean)false).booleanValue());
        serverTioConfigWs = imWsStarter.getServerTioConfig();
        serverTioConfigWs.setHeartbeatTimeout(Const.IM_HEARTBEAT_TIMEOUT);
        serverTioConfigWs.setReadBufferSize(P.getInt((String)"im.ws.readbuffersize", (Integer)1024).intValue());
        TioSiteImServerStarter.serverTioConfigWs.logWhenDecodeError = P.getBoolean((String)"im.ws.logWhenDecodeError", (Boolean)false);
        TioSiteImServerStarter.serverTioConfigWs.groups.setChannelContextComparator((Comparator)ChannelContextComparator.me);
        serverTioConfigWs.setName("Tio Site WS Im Server");
        serverTioConfigWs.setIpStatListener((IpStatListener)TioSiteIpStatListener.ws);
        TioSiteImServerStarter.serverTioConfigWs.ipStats.addDurations(Const.IpStatDuration.IPSTAT_DURATIONS);
        TioSiteImServerStarter.useSsl(serverTioConfigWs);
        serverTioConfigWs.share(serverTioConfigApp);
        TioSiteImServerStarter.serverTioConfigWs.packetConverter = ImToWsPacketConverter.me;
        if (Const.USE_TIO_CLU) {
            serverTioConfigWs.setCluClientChannelContexts(cluClientStarter.getClientChannelContexts());
            serverTioConfigWs.setCluClientTioConfig(cluClientStarter.getClientTioConfig());
            serverTioConfigWs.setTransferListener((TransferListener)ImTransferListener.me);
        }
        imWsStarter.start();
        LogUtils.logJvmStartTime((String)(TioSiteImServerStarter.class.getName() + "\uff1aimWsStarter.start()"));
        if (Boolean.getBoolean("tio.clu.client.starttest")) {
            cluClientStarter.startTest();
        }
    }

    private static void initRpc(CluClientStarter cluClientStarter) {
        RpcApi.scan(new String[]{RpcDemoImpl.class.getPackage().getName()}, cluClientStarter.getClientTioConfig());
    }

    private static void useSsl(ServerTioConfig serverTioConfig) throws Exception {
        String keyStoreFile = P.get((String)"ssl.keystore", null);
        String trustStoreFile = P.get((String)"ssl.truststore", null);
        String keyStorePwd = P.get((String)"ssl.pwd", null);
        serverTioConfig.useSsl(keyStoreFile, trustStoreFile, keyStorePwd);
    }

    static {
        packetDispatcher = null;
        tioSiteImServerAioHandler = null;
        tioSiteImServerAioListener = null;
        tioSiteImGroupListener = null;
        bindIp = null;
        serverTioConfigApp = null;
        tioServerApp = null;
        serverTioConfigWs = null;
        imWsStarter = null;
        cluClientStarter = null;
    }
}

