/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.clu;

import java.util.Date;
import java.util.List;
import org.tio.clu.client.bs.TransferListener;
import org.tio.clu.common.BindType;
import org.tio.clu.common.bs.TransferNtf;
import org.tio.core.intf.Packet;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.wx.friend.WxFriendChatNtf;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxFriendMsg;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.chat.SynService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.WriteLockHandler;

public class ImTransferListener
implements TransferListener {
    public static final ImTransferListener me = new ImTransferListener();

    public boolean onBeforeTransfer(Packet bsPacket, BindType bindType, TransferNtf transferNtf) {
        ImPacket imPacket = (ImPacket)bsPacket;
        block0 : switch (bindType) {
            case User: {
                Command command = imPacket.getCommand();
                switch (command) {
                    case WxFriendChatNtf: {
                        WxFriendChatNtf chatNtf = (WxFriendChatNtf)imPacket.getBodyObj();
                        if (chatNtf == null && StrUtil.isNotBlank((CharSequence)imPacket.getBodyStr())) {
                            chatNtf = (WxFriendChatNtf)Json.toBean((String)imPacket.getBodyStr(), WxFriendChatNtf.class);
                        }
                        this.p2pCacheDeal(chatNtf);
                        break block0;
                    }
                }
                break;
            }
        }
        return true;
    }

    public void onAfterTransfer(Packet bsPacket, BindType bindType, TransferNtf transferNtf) {
    }

    private void p2pCacheDeal(final WxFriendChatNtf chatNtf) {
        if (chatNtf != null && chatNtf.getChatlinkid() != null) {
            String key = chatNtf.getChatlinkid() + "";
            final int historyCount = ConfService.getInt((String)"im.history.chat.count.p2p", (Integer)FriendService.WX_FRIEND_MSG_LIMIT);
            ListWithLock listWithLock = (ListWithLock)Caches.getCache((CacheConfig)CacheConfig.WX_FRIEND_MSG_CHAT_5).get(key, ListWithLock.class);
            if (listWithLock != null) {
                listWithLock.handle((WriteLockHandler)new WriteLockHandler<List<WxFriendMsg>>(){

                    public void handler(List<WxFriendMsg> list) {
                        WxFriendMsg chatRecord = ImTransferListener.this.p2pNtfToMsg(chatNtf);
                        list.add(0, chatRecord);
                        while (list.size() > historyCount) {
                            list.remove(historyCount);
                        }
                    }
                });
                SynService.me.recordCluChatCache(chatNtf.getTouid(), chatNtf.getChatlinkid());
            }
        }
    }

    private WxFriendMsg p2pNtfToMsg(WxFriendChatNtf chatNtf) {
        WxFriendMsg chatRecord = new WxFriendMsg();
        chatRecord.setNick(chatNtf.getNick());
        chatRecord.setAvatar(chatNtf.getAvatar());
        chatRecord.setMid(chatNtf.getMid());
        chatRecord.setUid(chatNtf.getUid());
        chatRecord.setTouid(chatNtf.getTouid());
        chatRecord.setReadflag(chatNtf.getReadflag());
        chatRecord.setReadtime(chatNtf.getReadtime());
        chatRecord.setTime(new Date(chatNtf.getT()));
        chatRecord.setSendbysys(chatNtf.getSendbysys());
        chatRecord.setMsgtype(chatNtf.getMsgtype());
        chatRecord.setContenttype(chatNtf.getCt());
        String c = chatNtf.getC();
        chatRecord.setC(c);
        switch (chatNtf.getCt()) {
            case 1: {
                break;
            }
            case 4: {
                chatRecord.setAc(c);
                break;
            }
            case 2: {
                chatRecord.setBc(c);
                break;
            }
            case 3: {
                chatRecord.setFc(c);
                break;
            }
            case 6: {
                chatRecord.setIc(c);
                break;
            }
            case 5: {
                chatRecord.setVc(c);
                break;
            }
            case 9: {
                chatRecord.setCardc(c);
                break;
            }
            case 11: {
                chatRecord.setCall(c);
                break;
            }
            case 10: {
                chatRecord.setCall(c);
                break;
            }
        }
        return chatRecord;
    }

    public static void main(String[] args) {
    }
}

